/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.Map;
import org.apache.druid.java.util.common.MapUtils;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;

public class OmniDataSegmentArchiver
implements DataSegmentArchiver {
    private final Map<String, Supplier<DataSegmentArchiver>> archivers = new HashMap<String, Supplier<DataSegmentArchiver>>();

    @Inject
    public OmniDataSegmentArchiver(Map<String, Provider<DataSegmentArchiver>> archivers) {
        for (Map.Entry<String, Provider<DataSegmentArchiver>> entry : archivers.entrySet()) {
            String type = entry.getKey();
            Provider<DataSegmentArchiver> provider = entry.getValue();
            this.archivers.put(type, (Supplier<DataSegmentArchiver>)Suppliers.memoize(() -> provider.get()));
        }
    }

    public DataSegment archive(DataSegment segment) throws SegmentLoadingException {
        return this.getArchiver(segment).archive(segment);
    }

    public DataSegment restore(DataSegment segment) throws SegmentLoadingException {
        return this.getArchiver(segment).restore(segment);
    }

    private DataSegmentArchiver getArchiver(DataSegment segment) throws SegmentLoadingException {
        String type = MapUtils.getString((Map)segment.getLoadSpec(), (String)"type");
        Supplier<DataSegmentArchiver> archiver = this.archivers.get(type);
        if (archiver == null) {
            throw new SegmentLoadingException("Unknown loader type[%s].  Known types are %s", new Object[]{type, this.archivers.keySet()});
        }
        return (DataSegmentArchiver)archiver.get();
    }

    @VisibleForTesting
    public Map<String, Supplier<DataSegmentArchiver>> getArchivers() {
        return this.archivers;
    }
}

