/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.loading;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.io.File;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.HumanReadableBytes;

public class StorageLocationConfig {
    private final File path;
    private final long maxSize;
    @Nullable
    private final Double freeSpacePercent;

    @JsonCreator
    public StorageLocationConfig(@JsonProperty(value="path") File path, @JsonProperty(value="maxSize") @Nullable HumanReadableBytes maxSize, @JsonProperty(value="freeSpacePercent") @Nullable Double freeSpacePercent) {
        this(path, maxSize == null ? Long.MAX_VALUE : maxSize.getBytes(), freeSpacePercent);
    }

    public StorageLocationConfig(File path, long maxSize, Double freeSpacePercent) {
        this.path = (File)Preconditions.checkNotNull((Object)path, (Object)"path");
        this.maxSize = maxSize;
        this.freeSpacePercent = freeSpacePercent;
        Preconditions.checkArgument((this.maxSize > 0L ? 1 : 0) != 0, (String)"maxSize[%s] should be positive", (long)this.maxSize);
        Preconditions.checkArgument((this.freeSpacePercent == null || this.freeSpacePercent >= 0.0 ? 1 : 0) != 0, (String)"freeSpacePercent[%s] should be 0 or a positive double", (Object)this.freeSpacePercent);
    }

    @JsonProperty
    public File getPath() {
        return this.path;
    }

    @JsonProperty
    public long getMaxSize() {
        return this.maxSize;
    }

    @JsonProperty
    @Nullable
    public Double getFreeSpacePercent() {
        return this.freeSpacePercent;
    }

    public String toString() {
        return "StorageLocationConfig{path=" + this.path + ", maxSize=" + this.maxSize + ", freeSpacePercent=" + this.freeSpacePercent + '}';
    }
}

