/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;

public class CentralizedDatasourceSchemaConfig {
    public static final String PROPERTY_PREFIX = "druid.centralizedDatasourceSchema";
    public static final int SCHEMA_VERSION = 1;
    @JsonProperty
    private boolean enabled = false;
    @JsonProperty
    private boolean taskSchemaPublishDisabled = false;
    @JsonProperty
    private boolean backFillEnabled = true;
    @JsonProperty
    private long backFillPeriod = 60000L;

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public boolean isBackFillEnabled() {
        return this.backFillEnabled;
    }

    @JsonProperty
    public long getBackFillPeriod() {
        return this.backFillPeriod;
    }

    @JsonProperty
    public boolean isTaskSchemaPublishDisabled() {
        return this.taskSchemaPublishDisabled;
    }

    public static CentralizedDatasourceSchemaConfig create() {
        return new CentralizedDatasourceSchemaConfig();
    }

    public static CentralizedDatasourceSchemaConfig create(boolean enabled) {
        CentralizedDatasourceSchemaConfig config = new CentralizedDatasourceSchemaConfig();
        config.setEnabled(enabled);
        return config;
    }

    @VisibleForTesting
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @VisibleForTesting
    public void setBackFillEnabled(boolean backFillEnabled) {
        this.backFillEnabled = backFillEnabled;
    }

    @VisibleForTesting
    public void setBackFillPeriod(long backFillPeriod) {
        this.backFillPeriod = backFillPeriod;
    }
}

