/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Ints;
import com.google.inject.Inject;
import java.io.IOException;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.SchemaPayload;

@LazySingleton
public class FingerprintGenerator {
    private static final Logger log = new Logger(FingerprintGenerator.class);
    private final ObjectMapper objectMapper;

    @Inject
    public FingerprintGenerator(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String generateFingerprint(SchemaPayload schemaPayload, String dataSource, int version) {
        try {
            Hasher hasher = Hashing.sha256().newHasher();
            hasher.putBytes(this.objectMapper.writeValueAsBytes((Object)schemaPayload));
            hasher.putByte((byte)-1);
            hasher.putBytes(StringUtils.toUtf8((String)dataSource));
            hasher.putByte((byte)-1);
            hasher.putBytes(Ints.toByteArray((int)version));
            hasher.putByte((byte)-1);
            return BaseEncoding.base16().encode(hasher.hash().asBytes());
        }
        catch (IOException e) {
            log.error((Throwable)e, "Exception generating schema fingerprint (version[%d]) for datasource[%s], payload[%s].", new Object[]{version, dataSource, schemaPayload});
            throw DruidException.defensive((String)"Could not generate schema fingerprint (version[%d]) for datasource[%s].", (Object[])new Object[]{dataSource, version});
        }
    }
}

