/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.concurrent.ScheduledExecutorFactory;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.FingerprintGenerator;
import org.apache.druid.segment.metadata.SegmentSchemaCache;
import org.apache.druid.segment.metadata.SegmentSchemaManager;
import org.apache.druid.timeline.SegmentId;

@ManageLifecycle
public class SegmentSchemaBackFillQueue {
    private static final EmittingLogger log = new EmittingLogger(SegmentSchemaBackFillQueue.class);
    private static final int MAX_BATCH_SIZE = 500;
    private final BlockingDeque<SegmentSchemaManager.SegmentSchemaMetadataPlus> queue = new LinkedBlockingDeque<SegmentSchemaManager.SegmentSchemaMetadataPlus>();
    private final long executionPeriod;
    private final SegmentSchemaManager segmentSchemaManager;
    private final SegmentSchemaCache segmentSchemaCache;
    private final FingerprintGenerator fingerprintGenerator;
    private final ServiceEmitter emitter;
    private final CentralizedDatasourceSchemaConfig config;
    private final ScheduledExecutorService executor;
    @Nullable
    private ScheduledFuture<?> scheduledFuture = null;

    @Inject
    public SegmentSchemaBackFillQueue(SegmentSchemaManager segmentSchemaManager, ScheduledExecutorFactory scheduledExecutorFactory, SegmentSchemaCache segmentSchemaCache, FingerprintGenerator fingerprintGenerator, ServiceEmitter emitter, CentralizedDatasourceSchemaConfig config) {
        this.segmentSchemaManager = segmentSchemaManager;
        this.segmentSchemaCache = segmentSchemaCache;
        this.fingerprintGenerator = fingerprintGenerator;
        this.emitter = emitter;
        this.config = config;
        this.executionPeriod = config.getBackFillPeriod();
        this.executor = this.isEnabled() ? scheduledExecutorFactory.create(1, "SegmentSchemaBackFillQueue-%s") : null;
    }

    @LifecycleStop
    public void stop() {
        this.executor.shutdownNow();
        if (this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    public void onLeaderStart() {
        if (this.isEnabled()) {
            this.scheduledFuture = this.executor.scheduleAtFixedRate(this::processBatchesDueSafely, this.executionPeriod, this.executionPeriod, TimeUnit.MILLISECONDS);
        }
    }

    public void onLeaderStop() {
        if (this.isEnabled() && this.scheduledFuture != null) {
            this.scheduledFuture.cancel(true);
        }
    }

    public void add(SegmentId segmentId, RowSignature rowSignature, Map<String, AggregatorFactory> aggregators, long numRows) {
        SchemaPayload schemaPayload = new SchemaPayload(rowSignature, aggregators);
        SchemaPayloadPlus schemaMetadata = new SchemaPayloadPlus(schemaPayload, Long.valueOf(numRows));
        this.queue.add(new SegmentSchemaManager.SegmentSchemaMetadataPlus(segmentId, this.fingerprintGenerator.generateFingerprint(schemaMetadata.getSchemaPayload(), segmentId.getDataSource(), 1), schemaMetadata));
    }

    public boolean isEnabled() {
        return this.config.isEnabled() && this.config.isBackFillEnabled();
    }

    private void processBatchesDueSafely() {
        try {
            this.processBatchesDue();
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception backfilling segment schemas.", new Object[0]);
        }
    }

    @VisibleForTesting
    public void processBatchesDue() {
        if (this.queue.isEmpty()) {
            return;
        }
        Stopwatch stopwatch = Stopwatch.createStarted();
        log.info("Backfilling segment schema. Queue size is [%s].", new Object[]{this.queue.size()});
        int itemsToProcess = Math.min(500, this.queue.size());
        HashMap<String, List> polled = new HashMap<String, List>();
        for (int i = 0; i < itemsToProcess; ++i) {
            SegmentSchemaManager.SegmentSchemaMetadataPlus item = this.queue.poll();
            if (item == null) continue;
            polled.computeIfAbsent(item.getSegmentId().getDataSource(), value -> new ArrayList()).add(item);
        }
        for (Map.Entry entry : polled.entrySet()) {
            try {
                this.segmentSchemaManager.persistSchemaAndUpdateSegmentsTable((String)entry.getKey(), (List)entry.getValue(), 1);
                for (SegmentSchemaManager.SegmentSchemaMetadataPlus plus : (List)entry.getValue()) {
                    this.segmentSchemaCache.markMetadataQueryResultPublished(plus.getSegmentId());
                }
                this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setDimension("dataSource", entry.getKey()).setMetric("metadatacache/backfill/count", (Number)((List)entry.getValue()).size()));
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception persisting schema and updating segments table for datasource[%s].", new Object[]{entry.getKey()});
            }
        }
        this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric("metadatacache/backfill/time", (Number)stopwatch.millisElapsed()));
    }
}

