/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import java.util.Set;
import org.apache.druid.client.SegmentServerSelector;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.server.scheduling.HiLoQueryLaningStrategy;
import org.apache.druid.server.scheduling.ManualQueryLaningStrategy;
import org.apache.druid.server.scheduling.NoQueryLaningStrategy;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="strategy", defaultImpl=NoQueryLaningStrategy.class)
@JsonSubTypes(value={@JsonSubTypes.Type(name="none", value=NoQueryLaningStrategy.class), @JsonSubTypes.Type(name="hilo", value=HiLoQueryLaningStrategy.class), @JsonSubTypes.Type(name="manual", value=ManualQueryLaningStrategy.class)})
public interface QueryLaningStrategy {
    public Object2IntMap<String> getLaneLimits(int var1);

    public <T> Optional<String> computeLane(QueryPlus<T> var1, Set<SegmentServerSelector> var2);

    default public int computeLimitFromPercent(int totalLimit, int value) {
        return Ints.checkedCast((long)((long)Math.ceil((double)totalLimit * ((double)value / 100.0))));
    }
}

