/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.server.QuerySchedulerConfig;
import org.apache.druid.server.SubqueryGuardrailHelper;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.utils.JvmUtils;

public class SubqueryGuardrailHelperProvider
implements Provider<SubqueryGuardrailHelper> {
    private final LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider;
    private final ServerConfig serverConfig;
    private final QuerySchedulerConfig querySchedulerConfig;

    @Inject
    public SubqueryGuardrailHelperProvider(LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider, ServerConfig serverConfig, QuerySchedulerConfig querySchedulerConfig) {
        this.lookupExtractorFactoryContainerProvider = lookupExtractorFactoryContainerProvider;
        this.serverConfig = serverConfig;
        this.querySchedulerConfig = querySchedulerConfig;
    }

    @LazySingleton
    public SubqueryGuardrailHelper get() {
        int maxConcurrentQueries = this.querySchedulerConfig.getNumThreads() > 0 ? Math.min(this.querySchedulerConfig.getNumThreads(), this.serverConfig.getNumThreads()) : this.serverConfig.getNumThreads();
        return new SubqueryGuardrailHelper(this.lookupExtractorFactoryContainerProvider, JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes(), maxConcurrentQueries);
    }
}

