/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

public class SegmentChangeStatus {
    private final State state;
    @Nullable
    private final String failureCause;
    public static final SegmentChangeStatus SUCCESS = new SegmentChangeStatus(State.SUCCESS, null);
    public static final SegmentChangeStatus PENDING = new SegmentChangeStatus(State.PENDING, null);

    public static SegmentChangeStatus failed(String cause) {
        return new SegmentChangeStatus(State.FAILED, cause);
    }

    @JsonCreator
    private SegmentChangeStatus(@JsonProperty(value="state") State state, @JsonProperty(value="failureCause") @Nullable String failureCause) {
        this.state = (State)((Object)Preconditions.checkNotNull((Object)((Object)state), (Object)"state must be non-null"));
        this.failureCause = failureCause;
    }

    @JsonProperty
    public State getState() {
        return this.state;
    }

    @Nullable
    @JsonProperty
    public String getFailureCause() {
        return this.failureCause;
    }

    public String toString() {
        return "SegmentChangeStatus{state=" + (Object)((Object)this.state) + ", failureCause='" + this.failureCause + '\'' + '}';
    }

    public static enum State {
        SUCCESS,
        FAILED,
        PENDING;

    }
}

