/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import java.util.List;
import java.util.Stack;
import org.apache.druid.audit.AuditInfo;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfigAuditEntry;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.joda.time.DateTime;

public class DataSourceCompactionConfigHistory {
    private final Stack<DataSourceCompactionConfigAuditEntry> auditEntries = new Stack();
    private final String dataSource;

    public DataSourceCompactionConfigHistory(String dataSource) {
        this.dataSource = dataSource;
    }

    public void add(DruidCompactionConfig compactionConfig, AuditInfo auditInfo, DateTime auditTime) {
        boolean shouldAddEntry;
        DataSourceCompactionConfigAuditEntry previousEntry = this.auditEntries.isEmpty() ? null : this.auditEntries.peek();
        DataSourceCompactionConfigAuditEntry newEntry = new DataSourceCompactionConfigAuditEntry(compactionConfig.clusterConfig(), (DataSourceCompactionConfig)compactionConfig.findConfigForDatasource(this.dataSource).orNull(), auditInfo, auditTime);
        if (previousEntry == null) {
            shouldAddEntry = newEntry.getCompactionConfig() != null;
        } else {
            boolean bl = shouldAddEntry = !newEntry.hasSameConfig(previousEntry);
        }
        if (shouldAddEntry) {
            this.auditEntries.push(newEntry);
        }
    }

    public List<DataSourceCompactionConfigAuditEntry> getEntries() {
        return this.auditEntries;
    }
}

