/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.NewestSegmentFirstPolicy;
import org.apache.druid.server.coordinator.ClusterCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;

public class DruidCompactionConfig {
    public static final String CONFIG_KEY = "coordinator.compaction.config";
    private static final CompactionCandidateSearchPolicy DEFAULT_COMPACTION_POLICY = new NewestSegmentFirstPolicy(null);
    private static final DruidCompactionConfig EMPTY_INSTANCE = new DruidCompactionConfig(Collections.emptyList(), null, null, null, null);
    private final List<DataSourceCompactionConfig> compactionConfigs;
    private final double compactionTaskSlotRatio;
    private final int maxCompactionTaskSlots;
    private final boolean useAutoScaleSlots;
    private final CompactionCandidateSearchPolicy compactionPolicy;

    public DruidCompactionConfig withDatasourceConfigs(List<DataSourceCompactionConfig> compactionConfigs) {
        return new DruidCompactionConfig(compactionConfigs, this.compactionTaskSlotRatio, this.maxCompactionTaskSlots, this.useAutoScaleSlots, this.compactionPolicy);
    }

    public DruidCompactionConfig withClusterConfig(ClusterCompactionConfig update) {
        return new DruidCompactionConfig(this.compactionConfigs, (Double)Configs.valueOrDefault((Object)update.getCompactionTaskSlotRatio(), (Object)this.compactionTaskSlotRatio), Configs.valueOrDefault((Integer)update.getMaxCompactionTaskSlots(), (int)this.maxCompactionTaskSlots), Configs.valueOrDefault((Boolean)update.getUseAutoScaleSlots(), (boolean)this.useAutoScaleSlots), (CompactionCandidateSearchPolicy)Configs.valueOrDefault((Object)update.getCompactionPolicy(), (Object)this.compactionPolicy));
    }

    public DruidCompactionConfig withDatasourceConfig(DataSourceCompactionConfig dataSourceConfig) {
        Map<String, DataSourceCompactionConfig> configs = this.dataSourceToCompactionConfigMap();
        configs.put(dataSourceConfig.getDataSource(), dataSourceConfig);
        return this.withDatasourceConfigs(new ArrayList<DataSourceCompactionConfig>(configs.values()));
    }

    public static DruidCompactionConfig empty() {
        return EMPTY_INSTANCE;
    }

    @JsonCreator
    public DruidCompactionConfig(@JsonProperty(value="compactionConfigs") List<DataSourceCompactionConfig> compactionConfigs, @JsonProperty(value="compactionTaskSlotRatio") @Nullable Double compactionTaskSlotRatio, @JsonProperty(value="maxCompactionTaskSlots") @Nullable Integer maxCompactionTaskSlots, @JsonProperty(value="useAutoScaleSlots") @Nullable Boolean useAutoScaleSlots, @JsonProperty(value="compactionPolicy") @Nullable CompactionCandidateSearchPolicy compactionPolicy) {
        this.compactionConfigs = (List)Configs.valueOrDefault(compactionConfigs, Collections.emptyList());
        this.compactionTaskSlotRatio = (Double)Configs.valueOrDefault((Object)compactionTaskSlotRatio, (Object)0.1);
        this.maxCompactionTaskSlots = Configs.valueOrDefault((Integer)maxCompactionTaskSlots, (int)Integer.MAX_VALUE);
        this.useAutoScaleSlots = Configs.valueOrDefault((Boolean)useAutoScaleSlots, (boolean)false);
        this.compactionPolicy = (CompactionCandidateSearchPolicy)Configs.valueOrDefault((Object)compactionPolicy, (Object)DEFAULT_COMPACTION_POLICY);
    }

    @JsonProperty
    public List<DataSourceCompactionConfig> getCompactionConfigs() {
        return this.compactionConfigs;
    }

    @JsonProperty
    public double getCompactionTaskSlotRatio() {
        return this.compactionTaskSlotRatio;
    }

    @JsonProperty
    public int getMaxCompactionTaskSlots() {
        return this.maxCompactionTaskSlots;
    }

    @JsonProperty
    public boolean isUseAutoScaleSlots() {
        return this.useAutoScaleSlots;
    }

    public ClusterCompactionConfig clusterConfig() {
        return new ClusterCompactionConfig(this.compactionTaskSlotRatio, this.maxCompactionTaskSlots, this.useAutoScaleSlots, this.compactionPolicy);
    }

    public Map<String, DataSourceCompactionConfig> dataSourceToCompactionConfigMap() {
        return this.getCompactionConfigs().stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
    }

    public Optional<DataSourceCompactionConfig> findConfigForDatasource(String dataSource) {
        for (DataSourceCompactionConfig dataSourceConfig : this.getCompactionConfigs()) {
            if (!dataSource.equals(dataSourceConfig.getDataSource())) continue;
            return Optional.of((Object)dataSourceConfig);
        }
        return Optional.absent();
    }

    @JsonProperty
    public CompactionCandidateSearchPolicy getCompactionPolicy() {
        return this.compactionPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidCompactionConfig that = (DruidCompactionConfig)o;
        return Double.compare(that.compactionTaskSlotRatio, this.compactionTaskSlotRatio) == 0 && this.maxCompactionTaskSlots == that.maxCompactionTaskSlots && this.useAutoScaleSlots == that.useAutoScaleSlots && Objects.equals(this.compactionPolicy, that.compactionPolicy) && Objects.equals(this.compactionConfigs, that.compactionConfigs);
    }

    public int hashCode() {
        return Objects.hash(this.compactionConfigs, this.compactionTaskSlotRatio, this.maxCompactionTaskSlots, this.useAutoScaleSlots, this.compactionPolicy);
    }

    public String toString() {
        return "CoordinatorCompactionConfig{compactionConfigs=" + this.compactionConfigs + ", compactionTaskSlotRatio=" + this.compactionTaskSlotRatio + ", maxCompactionTaskSlots=" + this.maxCompactionTaskSlots + ", useAutoScaleSlots=" + this.useAutoScaleSlots + ", compactionPolicy=" + this.compactionPolicy + '}';
    }
}

