/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.google.common.collect.EvictingQueue;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.DruidCoordinator;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorDuty;
import org.apache.druid.server.coordinator.duty.DutyGroupStatus;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.CoordinatorStat;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public class CoordinatorDutyGroup {
    private static final Logger log = new Logger(CoordinatorDutyGroup.class);
    private final String name;
    private final Duration period;
    private final List<CoordinatorDuty> duties;
    private final List<String> dutyNames;
    private final DruidCoordinator.DutyGroupHelper coordinator;
    private final AtomicReference<DateTime> lastRunStartTime = new AtomicReference();
    private final AtomicReference<DateTime> lastRunEndTime = new AtomicReference();
    private final EvictingQueue<Long> runTimes = EvictingQueue.create((int)20);
    private final EvictingQueue<Long> gapTimes = EvictingQueue.create((int)20);

    public CoordinatorDutyGroup(String name, List<CoordinatorDuty> duties, Duration period, DruidCoordinator.DutyGroupHelper coordinator) {
        this.name = name;
        this.duties = duties;
        this.period = period;
        this.dutyNames = duties.stream().map(duty -> duty.getClass().getName()).collect(Collectors.toList());
        this.coordinator = coordinator;
        log.info("Created dutyGroup[%s] with period[%s] and duties[%s].", new Object[]{name, period, this.dutyNames});
    }

    public String getName() {
        return this.name;
    }

    public Duration getPeriod() {
        return this.period;
    }

    public synchronized DutyGroupStatus getStatus() {
        return new DutyGroupStatus(this.name, this.period, this.dutyNames, this.lastRunStartTime.get(), this.lastRunEndTime.get(), this.computeWindowAverage(this.runTimes), this.computeWindowAverage(this.gapTimes));
    }

    public void run(DruidCoordinatorRuntimeParams params) {
        this.markRunStarted();
        boolean coordinationPaused = params.getCoordinatorDynamicConfig().getPauseCoordination();
        if (coordinationPaused && this.coordinator.isLeader()) {
            log.info("Coordination has been paused. Duties will not run until coordination is resumed.", new Object[0]);
            return;
        }
        CoordinatorRunStats stats = params.getCoordinatorStats();
        for (CoordinatorDuty duty : this.duties) {
            if (!this.coordinator.isLeader()) continue;
            Stopwatch dutyRunTime = Stopwatch.createStarted();
            params = duty.run(params);
            dutyRunTime.stop();
            String dutyName = duty.getClass().getName();
            if (params == null) {
                log.warn("Stopping run for group[%s] on request of duty[%s].", new Object[]{this.name, dutyName});
                return;
            }
            stats.add(Stats.CoordinatorRun.DUTY_RUN_TIME, RowKey.of(Dimension.DUTY, dutyName), dutyRunTime.millisElapsed());
        }
        if (stats.rowCount() > 0) {
            stats.forEachStat(this::emitStat);
            String statsTable = stats.buildStatsTable();
            if (!statsTable.isEmpty()) {
                log.info("Collected stats for duty group[%s]: %s", new Object[]{this.name, statsTable});
            }
        }
        long runMillis = this.markRunCompleted();
        this.emitStat(Stats.CoordinatorRun.GROUP_RUN_TIME, RowKey.empty(), runMillis);
    }

    private void emitStat(CoordinatorStat stat, RowKey rowKey, long value) {
        if (stat.shouldEmit()) {
            this.coordinator.emitStat(stat, rowKey, value);
        }
    }

    private synchronized long computeWindowAverage(EvictingQueue<Long> window) {
        int numEntries = window.size();
        if (numEntries > 0) {
            long totalTimeMillis = window.stream().mapToLong(Long::longValue).sum();
            return totalTimeMillis / (long)numEntries;
        }
        return 0L;
    }

    private synchronized void addToWindow(EvictingQueue<Long> window, long value) {
        window.add((Object)value);
    }

    private void markRunStarted() {
        DateTime now = DateTimes.nowUtc();
        DateTime lastStart = this.lastRunStartTime.getAndSet(now);
        if (lastStart != null) {
            this.addToWindow(this.gapTimes, now.getMillis() - lastStart.getMillis());
        }
    }

    private long markRunCompleted() {
        DateTime now = DateTimes.nowUtc();
        this.lastRunEndTime.set(now);
        long runtimeMillis = now.getMillis() - this.lastRunStartTime.get().getMillis();
        this.addToWindow(this.runTimes, runtimeMillis);
        return runtimeMillis;
    }
}

