/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Map;

public class ReplicationThrottler {
    private final int replicationThrottleLimit;
    private final Object2IntOpenHashMap<String> tierToNumAssigned = new Object2IntOpenHashMap();
    private final Object2IntOpenHashMap<String> tierToMaxAssignments = new Object2IntOpenHashMap();

    public ReplicationThrottler(Map<String, Integer> tierToLoadingReplicaCount, int replicationThrottleLimit) {
        this.replicationThrottleLimit = replicationThrottleLimit;
        if (tierToLoadingReplicaCount != null) {
            tierToLoadingReplicaCount.forEach((tier, numLoadingReplicas) -> this.tierToMaxAssignments.addTo(tier, Math.max(0, replicationThrottleLimit - numLoadingReplicas)));
        }
    }

    public boolean isReplicationThrottledForTier(String tier) {
        return this.tierToNumAssigned.getOrDefault((Object)tier, 0) >= this.tierToMaxAssignments.getOrDefault((Object)tier, this.replicationThrottleLimit);
    }

    public void incrementAssignedReplicas(String tier) {
        this.tierToNumAssigned.addTo((Object)tier, 1);
    }
}

