/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.sun.jersey.spi.container.ResourceFilters;
import java.util.Arrays;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.http.security.StateResourceFilter;

@Path(value="/druid/coordinator/v1/cluster")
@LazySingleton
@ResourceFilters(value={StateResourceFilter.class})
public class ClusterResource {
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;

    @Inject
    public ClusterResource(DruidNodeDiscoveryProvider discoveryProvider) {
        this.druidNodeDiscoveryProvider = discoveryProvider;
    }

    @GET
    @Produces(value={"application/json"})
    public Response getClusterServers(@QueryParam(value="full") boolean full) {
        Collection<Object> routerNodes;
        Collection<Object> indexerNodes;
        ImmutableMap.Builder entityBuilder = new ImmutableMap.Builder();
        entityBuilder.put((Object)NodeRole.COORDINATOR, this.getNodes(NodeRole.COORDINATOR, full));
        entityBuilder.put((Object)NodeRole.OVERLORD, this.getNodes(NodeRole.OVERLORD, full));
        entityBuilder.put((Object)NodeRole.BROKER, this.getNodes(NodeRole.BROKER, full));
        entityBuilder.put((Object)NodeRole.HISTORICAL, this.getNodes(NodeRole.HISTORICAL, full));
        Collection<Object> mmNodes = this.getNodes(NodeRole.MIDDLE_MANAGER, full);
        if (!mmNodes.isEmpty()) {
            entityBuilder.put((Object)NodeRole.MIDDLE_MANAGER, mmNodes);
        }
        if (!(indexerNodes = this.getNodes(NodeRole.INDEXER, full)).isEmpty()) {
            entityBuilder.put((Object)NodeRole.INDEXER, indexerNodes);
        }
        if (!(routerNodes = this.getNodes(NodeRole.ROUTER, full)).isEmpty()) {
            entityBuilder.put((Object)NodeRole.ROUTER, routerNodes);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)entityBuilder.build()).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{nodeRole}")
    public Response getClusterServers(@PathParam(value="nodeRole") NodeRole nodeRole, @QueryParam(value="full") boolean full) {
        if (nodeRole == null) {
            return Response.serverError().status(Response.Status.BAD_REQUEST).entity((Object)("Invalid nodeRole of null. Valid node roles are " + Arrays.toString(NodeRole.values()))).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(this.getNodes(nodeRole, full)).build();
    }

    private Collection<Object> getNodes(NodeRole nodeRole, boolean full) {
        Collection<Object> discoveryDruidNodes = this.druidNodeDiscoveryProvider.getForNodeRole(nodeRole).getAllNodes();
        if (full) {
            return discoveryDruidNodes;
        }
        return Collections2.transform(discoveryDruidNodes, discoveryDruidNode -> Node.from(discoveryDruidNode.getDruidNode()));
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private static class Node {
        private final String host;
        private final String service;
        private final Integer plaintextPort;
        private final Integer tlsPort;

        @JsonCreator
        public Node(String host, String service, Integer plaintextPort, Integer tlsPort) {
            this.host = host;
            this.service = service;
            this.plaintextPort = plaintextPort;
            this.tlsPort = tlsPort;
        }

        @JsonProperty
        public String getHost() {
            return this.host;
        }

        @JsonProperty
        public String getService() {
            return this.service;
        }

        @JsonProperty
        public Integer getPlaintextPort() {
            return this.plaintextPort;
        }

        @JsonProperty
        public Integer getTlsPort() {
            return this.tlsPort;
        }

        public static Node from(DruidNode druidNode) {
            return new Node(druidNode.getHost(), druidNode.getServiceName(), druidNode.getPlaintextPort() > 0 ? Integer.valueOf(druidNode.getPlaintextPort()) : null, druidNode.getTlsPort() > 0 ? Integer.valueOf(druidNode.getTlsPort()) : null);
        }
    }
}

