/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.router;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class RendezvousHasher {
    private static final HashFunction HASH_FN = Hashing.murmur3_128();

    public String chooseNode(Set<String> nodeIds, byte[] key) {
        if (nodeIds.isEmpty()) {
            return null;
        }
        long maxHash = Long.MIN_VALUE;
        String maxNode = null;
        for (String nodeId : nodeIds) {
            long combinedHash = HASH_FN.newHasher().putString((CharSequence)nodeId, StandardCharsets.UTF_8).putBytes(key).hash().asLong();
            if (maxNode == null) {
                maxHash = combinedHash;
                maxNode = nodeId;
                continue;
            }
            if (combinedHash <= maxHash) continue;
            maxHash = combinedHash;
            maxNode = nodeId;
        }
        return maxNode;
    }
}

