/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.parquet;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.druid.data.input.parquet.ParquetInputFormat;
import org.apache.druid.data.input.parquet.avro.ParquetAvroHadoopInputRowParser;
import org.apache.druid.data.input.parquet.guice.Parquet;
import org.apache.druid.data.input.parquet.simple.ParquetHadoopInputRowParser;
import org.apache.druid.data.input.parquet.simple.ParquetParseSpec;
import org.apache.druid.initialization.DruidModule;
import org.apache.hadoop.conf.Configuration;

public class ParquetExtensionsModule
implements DruidModule {
    static final String PARQUET_SIMPLE_INPUT_PARSER_TYPE = "parquet";
    static final String PARQUET_SIMPLE_PARSE_SPEC_TYPE = "parquet";
    static final String PARQUET_AVRO_INPUT_PARSER_TYPE = "parquet-avro";
    static final String PARQUET_AVRO_PARSE_SPEC_TYPE = "avro";
    private Properties props = null;

    @Inject
    public void setProperties(Properties props) {
        this.props = props;
    }

    public List<? extends Module> getJacksonModules() {
        return Collections.singletonList(new SimpleModule("ParquetInputRowParserModule").registerSubtypes(new NamedType[]{new NamedType(ParquetAvroHadoopInputRowParser.class, PARQUET_AVRO_INPUT_PARSER_TYPE), new NamedType(ParquetHadoopInputRowParser.class, "parquet"), new NamedType(ParquetParseSpec.class, "parquet"), new NamedType(ParquetInputFormat.class, "parquet")}));
    }

    public void configure(Binder binder) {
        Configuration conf = new Configuration();
        conf.setClassLoader(this.getClass().getClassLoader());
        if (this.props != null) {
            for (String propName : this.props.stringPropertyNames()) {
                if (!propName.startsWith("hadoop.")) continue;
                conf.set(propName.substring("hadoop.".length()), this.props.getProperty(propName));
            }
        }
        binder.bind(Configuration.class).annotatedWith(Parquet.class).toInstance((Object)conf);
    }
}

