/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expressions;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.guice.BloomFilterSerializersModule;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.aggregation.bloom.BloomFilterAggregatorFactory;
import org.apache.druid.query.filter.BloomKFilter;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;

public class BloomFilterExpressions {
    public static final ExpressionType BLOOM_FILTER_TYPE = ExpressionType.fromColumnTypeStrict((TypeSignature)BloomFilterAggregatorFactory.TYPE);

    public static class TestExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String FN_NAME = "bloom_filter_test";

        public String name() {
            return FN_NAME;
        }

        public Expr apply(List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 2);
            final Expr arg = args.get(0);
            Expr filterExpr = args.get(1);
            if (filterExpr.isLiteral() && filterExpr.getLiteralValue() instanceof String) {
                BloomKFilter filter;
                String serializedFilter = (String)filterExpr.getLiteralValue();
                byte[] decoded = StringUtils.decodeBase64String((String)serializedFilter);
                try {
                    filter = BloomFilterSerializersModule.bloomKFilterFromBytes(decoded);
                }
                catch (IOException ioe) {
                    throw this.processingFailed(ioe, "failed to deserialize bloom filter", new Object[0]);
                }
                class BloomExpr
                extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                    private final BloomKFilter filter;

                    BloomExpr(BloomKFilter filter, List<Expr> args) {
                        super((ExprMacroTable.ExprMacro)this$0, args);
                        this.filter = filter;
                    }

                    @Nonnull
                    public ExprEval eval(Expr.ObjectBinding bindings) {
                        ExprEval evaluated = arg.eval(bindings);
                        boolean matches = false;
                        switch ((ExprType)evaluated.type().getType()) {
                            case STRING: {
                                String stringVal = (String)evaluated.value();
                                if (stringVal == null) {
                                    matches = this.nullMatch();
                                    break;
                                }
                                matches = this.filter.testString(stringVal);
                                break;
                            }
                            case DOUBLE: {
                                Double doubleVal = (Double)evaluated.value();
                                if (doubleVal == null) {
                                    matches = this.nullMatch();
                                    break;
                                }
                                matches = this.filter.testDouble(doubleVal);
                                break;
                            }
                            case LONG: {
                                Long longVal = (Long)evaluated.value();
                                matches = longVal == null ? this.nullMatch() : this.filter.testLong(longVal);
                            }
                        }
                        return ExprEval.ofLongBoolean((boolean)matches);
                    }

                    private boolean nullMatch() {
                        return this.filter.testBytes(null, 0, 0);
                    }

                    @Nullable
                    public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                        return ExpressionType.LONG;
                    }
                }
                return new BloomExpr(filter, args);
            }
            class DynamicBloomExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                public DynamicBloomExpr(List<Expr> args) {
                    super((ExprMacroTable.ExprMacro)TestExprMacro.this, args);
                }

                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval bloomy = ((Expr)this.args.get(1)).eval(bindings);
                    if (!bloomy.type().equals((Object)BLOOM_FILTER_TYPE) || !bloomy.type().is((TypeDescriptor)ExprType.COMPLEX) && bloomy.value() instanceof BloomKFilter) {
                        throw TestExprMacro.this.validationFailed("must take a bloom filter as the second argument", new Object[0]);
                    }
                    BloomKFilter filter = (BloomKFilter)bloomy.value();
                    assert (filter != null);
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    boolean matches = false;
                    switch ((ExprType)input.type().getType()) {
                        case STRING: {
                            String stringVal = (String)input.value();
                            if (stringVal == null) {
                                matches = this.nullMatch(filter);
                                break;
                            }
                            matches = filter.testString(stringVal);
                            break;
                        }
                        case DOUBLE: {
                            Double doubleVal = (Double)input.value();
                            if (doubleVal == null) {
                                matches = this.nullMatch(filter);
                                break;
                            }
                            matches = filter.testDouble(doubleVal);
                            break;
                        }
                        case LONG: {
                            Long longVal = (Long)input.value();
                            matches = longVal == null ? this.nullMatch(filter) : filter.testLong(longVal);
                        }
                    }
                    return ExprEval.ofLongBoolean((boolean)matches);
                }

                private boolean nullMatch(BloomKFilter filter) {
                    return filter.testBytes(null, 0, 0);
                }

                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return ExpressionType.LONG;
                }
            }
            return new DynamicBloomExpr(args);
        }
    }

    public static class AddExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String FN_NAME = "bloom_filter_add";

        public String name() {
            return FN_NAME;
        }

        public Expr apply(List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 2);
            class BloomExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                BloomExpr(List<Expr> args) {
                    super((ExprMacroTable.ExprMacro)AddExprMacro.this, args);
                }

                public ExprEval eval(Expr.ObjectBinding bindings) {
                    ExprEval bloomy = ((Expr)this.args.get(1)).eval(bindings);
                    if (!bloomy.type().equals((Object)BLOOM_FILTER_TYPE) || !bloomy.type().is((TypeDescriptor)ExprType.COMPLEX) && bloomy.value() instanceof BloomKFilter) {
                        throw AddExprMacro.this.validationFailed("must take a bloom filter as the second argument", new Object[0]);
                    }
                    BloomKFilter filter = (BloomKFilter)bloomy.value();
                    assert (filter != null);
                    ExprEval input = ((Expr)this.args.get(0)).eval(bindings);
                    if (input.value() == null) {
                        filter.addBytes(null, 0, 0);
                    } else {
                        switch ((ExprType)input.type().getType()) {
                            case STRING: {
                                filter.addString(input.asString());
                                break;
                            }
                            case DOUBLE: {
                                filter.addDouble(input.asDouble());
                                break;
                            }
                            case LONG: {
                                filter.addLong(input.asLong());
                                break;
                            }
                            case COMPLEX: {
                                if (BLOOM_FILTER_TYPE.equals((Object)input.type()) || bloomy.type().is((TypeDescriptor)ExprType.COMPLEX) && bloomy.value() instanceof BloomKFilter) {
                                    filter.merge((BloomKFilter)input.value());
                                    break;
                                }
                            }
                            default: {
                                throw AddExprMacro.this.validationFailed("cannot add [%s] to a bloom filter", new Object[]{input.type()});
                            }
                        }
                    }
                    return ExprEval.ofComplex((ExpressionType)BLOOM_FILTER_TYPE, (Object)filter);
                }

                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return BLOOM_FILTER_TYPE;
                }
            }
            return new BloomExpr(args);
        }
    }

    public static class CreateExprMacro
    implements ExprMacroTable.ExprMacro {
        public static final String FN_NAME = "bloom_filter";

        public String name() {
            return FN_NAME;
        }

        public Expr apply(List<Expr> args) {
            this.validationHelperCheckArgumentCount(args, 1);
            Expr expectedSizeArg = args.get(0);
            if (!expectedSizeArg.isLiteral() || expectedSizeArg.getLiteralValue() == null) {
                throw this.validationFailed("argument must be a LONG constant", new Object[0]);
            }
            class BloomExpr
            extends ExprMacroTable.BaseScalarMacroFunctionExpr {
                final int expectedSize;

                public BloomExpr(List<Expr> args) {
                    super((ExprMacroTable.ExprMacro)CreateExprMacro.this, args);
                    this.expectedSize = args.get(0).eval(InputBindings.nilBindings()).asInt();
                }

                public ExprEval eval(Expr.ObjectBinding bindings) {
                    return ExprEval.ofComplex((ExpressionType)BLOOM_FILTER_TYPE, (Object)new BloomKFilter(this.expectedSize));
                }

                @Nullable
                public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                    return BLOOM_FILTER_TYPE;
                }
            }
            return new BloomExpr(args);
        }
    }
}

