/*
 * Decompiled with CFR 0.152.
 */
package io.timeandspace.cronscheduler;

import io.timeandspace.cronscheduler.CronTask;
import io.timeandspace.cronscheduler.MathUtils;
import io.timeandspace.cronscheduler.PeriodicScheduling;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.util.concurrent.TimeUnit;

class RoundWallTimeInDayPeriodicScheduling<V>
extends PeriodicScheduling<V> {
    private final ZoneId zoneId;
    private final long periodSeconds;
    private final boolean skippingToLatest;
    private long nextScheduledRunTimeSeconds;

    RoundWallTimeInDayPeriodicScheduling(Clock timeProvider, CronTask task, ZoneId zoneId, long periodSeconds, boolean skippingToLatest) {
        super(timeProvider, task);
        this.zoneId = zoneId;
        this.periodSeconds = periodSeconds;
        this.skippingToLatest = skippingToLatest;
        Instant currentTime = timeProvider.instant();
        long definitelySchedulableRunTimeSeconds = RoundWallTimeInDayPeriodicScheduling.rewindToValidMidnight(ZonedDateTime.ofInstant(currentTime, zoneId)).toEpochSecond();
        long currentTimeSeconds = currentTime.getEpochSecond();
        ZoneRules zoneRules = zoneId.getRules();
        long firstScheduledRunTimeSeconds = definitelySchedulableRunTimeSeconds;
        while (firstScheduledRunTimeSeconds < currentTimeSeconds) {
            firstScheduledRunTimeSeconds = RoundWallTimeInDayPeriodicScheduling.computeNextRunTimeSeconds(zoneRules, periodSeconds, firstScheduledRunTimeSeconds);
        }
        this.nextScheduledRunTimeSeconds = firstScheduledRunTimeSeconds;
    }

    private static ZonedDateTime rewindToValidMidnight(ZonedDateTime zonedDateTime) {
        ZoneId zone = zonedDateTime.getZone();
        LocalDate localDate = zonedDateTime.toLocalDate();
        ZonedDateTime maybeMidnight;
        while ((maybeMidnight = localDate.atStartOfDay(zone)).getHour() != 0 || maybeMidnight.getMinute() != 0) {
            localDate = localDate.minusDays(1L);
        }
        return maybeMidnight;
    }

    @Override
    public V call() throws Exception {
        if (this.skippingToLatest) {
            long candidateLatestScheduledRunTimeSeconds;
            Instant currentTime = this.timeProvider.instant();
            long currentTimeSeconds = currentTime.getEpochSecond();
            ZoneRules zoneRules = this.zoneId.getRules();
            while ((candidateLatestScheduledRunTimeSeconds = RoundWallTimeInDayPeriodicScheduling.computeNextRunTimeSeconds(zoneRules, this.periodSeconds, this.nextScheduledRunTimeSeconds)) <= currentTimeSeconds) {
                this.nextScheduledRunTimeSeconds = candidateLatestScheduledRunTimeSeconds;
            }
        }
        this.task.run(this.nextScheduledRunTimeMillis());
        return null;
    }

    @Override
    public void setNextRunTime() {
        this.nextScheduledRunTimeSeconds = RoundWallTimeInDayPeriodicScheduling.computeNextRunTimeSeconds(this.zoneId.getRules(), this.periodSeconds, this.nextScheduledRunTimeSeconds);
    }

    private static long computeNextRunTimeSeconds(ZoneRules zoneRules, long periodSeconds, long prevRunTime) {
        ZoneOffsetTransition nextTransition = zoneRules.nextTransition(Instant.ofEpochSecond(prevRunTime));
        long nextOrdinaryScheduledRunTimeSeconds = prevRunTime + periodSeconds;
        if (nextTransition == null || nextTransition.getInstant().getEpochSecond() > nextOrdinaryScheduledRunTimeSeconds) {
            return nextOrdinaryScheduledRunTimeSeconds;
        }
        int secondsSinceStartOfDayAfterTransition = RoundWallTimeInDayPeriodicScheduling.getSecondsSinceStartOfDay(nextTransition.getDateTimeAfter());
        long nextRoundTimeSecondsInDay = MathUtils.roundUp(secondsSinceStartOfDayAfterTransition, periodSeconds);
        long schedulingDelayAfterTransitionSeconds = nextRoundTimeSecondsInDay - (long)secondsSinceStartOfDayAfterTransition;
        return nextTransition.getInstant().getEpochSecond() + schedulingDelayAfterTransitionSeconds;
    }

    private static long computePrevRunTimeSeconds(ZoneRules zoneRules, long periodSeconds, long nextRunTime) {
        ZoneOffsetTransition prevTransition = zoneRules.previousTransition(Instant.ofEpochSecond(nextRunTime + 1L));
        long prevOrdinaryScheduledRunTimeSeconds = nextRunTime - periodSeconds;
        if (prevTransition == null || prevTransition.getInstant().getEpochSecond() <= prevOrdinaryScheduledRunTimeSeconds) {
            return prevOrdinaryScheduledRunTimeSeconds;
        }
        int secondsSinceStartOfDayBeforeTransition = RoundWallTimeInDayPeriodicScheduling.getSecondsSinceStartOfDay(prevTransition.getDateTimeBefore());
        long prevRoundTimeSecondsInDay = MathUtils.roundDown(secondsSinceStartOfDayBeforeTransition, periodSeconds);
        if (prevRoundTimeSecondsInDay == (long)secondsSinceStartOfDayBeforeTransition) {
            prevRoundTimeSecondsInDay -= periodSeconds;
        }
        long durationSincePrevRoundTimeBeforeTransitionSeconds = (long)secondsSinceStartOfDayBeforeTransition - prevRoundTimeSecondsInDay;
        return prevTransition.getInstant().getEpochSecond() - durationSincePrevRoundTimeBeforeTransitionSeconds;
    }

    private static int getSecondsSinceStartOfDay(LocalDateTime dt) {
        return Math.toIntExact(TimeUnit.MINUTES.toSeconds(TimeUnit.HOURS.toMinutes(dt.getHour()) + (long)dt.getMinute()) + (long)dt.getSecond());
    }

    @Override
    public boolean rewind(long newTimeMillis) {
        if (this.nextScheduledRunTimeMillis() <= newTimeMillis) {
            return false;
        }
        ZoneRules zoneRules = this.zoneId.getRules();
        while (this.nextScheduledRunTimeMillis() > newTimeMillis) {
            this.nextScheduledRunTimeSeconds = RoundWallTimeInDayPeriodicScheduling.computePrevRunTimeSeconds(zoneRules, this.periodSeconds, this.nextScheduledRunTimeSeconds);
        }
        return true;
    }

    @Override
    public long nextScheduledRunTimeMillis() {
        return TimeUnit.SECONDS.toMillis(this.nextScheduledRunTimeSeconds);
    }
}

