/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.annotation.SdkTestInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.SdkClock;
import com.amazonaws.auth.Signer;
import com.amazonaws.auth.StaticSignerProvider;
import com.amazonaws.auth.presign.PresignerFacade;
import com.amazonaws.auth.presign.PresignerParams;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.auth.SignerProvider;
import com.amazonaws.regions.Region;
import com.amazonaws.services.rds.auth.GetIamAuthTokenRequest;
import com.amazonaws.util.ImmutableMapParameter;
import com.amazonaws.util.ValidationUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.joda.time.DateTime;

@ThreadSafe
public class RdsIamAuthTokenGenerator {
    private static final String SERVICE_NAME = "rds-db";
    private static final int DEFAULT_EXPIRATION_IN_MINUTES = 15;
    private final PresignerFacade presignerFacade;
    private final SdkClock clock;

    private RdsIamAuthTokenGenerator(AWSCredentialsProvider credentialsProvider, String region) {
        this(PresignerParams.builder().credentialsProvider((AWSCredentialsProvider)ValidationUtils.assertNotNull((Object)credentialsProvider, (String)"credentialsProvider")).signerProvider(RdsIamAuthTokenGenerator.createSignerProvider(region)).build());
    }

    @SdkTestInternalApi
    RdsIamAuthTokenGenerator(PresignerParams presignerParams) {
        this.presignerFacade = new PresignerFacade(presignerParams);
        this.clock = presignerParams.clock();
    }

    private static SignerProvider createSignerProvider(String region) {
        AWS4Signer signer = new AWS4Signer();
        signer.setRegionName(ValidationUtils.assertStringNotEmpty((String)region, (String)"region"));
        signer.setServiceName(SERVICE_NAME);
        return new StaticSignerProvider((Signer)signer);
    }

    public String getAuthToken(GetIamAuthTokenRequest request) throws AmazonClientException {
        DefaultRequest signableRequest = new DefaultRequest(SERVICE_NAME);
        signableRequest.setResourcePath("/");
        this.setEndpoint((DefaultRequest<Void>)signableRequest, request);
        this.setParameters((DefaultRequest<Void>)signableRequest, request);
        signableRequest.setHttpMethod(HttpMethodName.GET);
        return this.presignerFacade.presign((Request)signableRequest, this.getExpirationDate()).toExternalForm().replaceFirst("http://", "");
    }

    private void setEndpoint(DefaultRequest<Void> signableRequest, GetIamAuthTokenRequest request) {
        try {
            signableRequest.setEndpoint(new URI(String.format("http://%s:%d", request.getHostname(), request.getPort())));
        }
        catch (URISyntaxException e) {
            throw new AmazonClientException("Invalid endpoint provided", (Throwable)e);
        }
    }

    private void setParameters(DefaultRequest<Void> signableRequest, GetIamAuthTokenRequest request) {
        signableRequest.setParameters((Map)ImmutableMapParameter.of((Object)"DBUser", Collections.singletonList(request.getUserName()), (Object)"Action", Collections.singletonList("connect")));
    }

    private Date getExpirationDate() {
        return new DateTime(this.clock.currentTimeMillis()).plusMinutes(15).toDate();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AWSCredentialsProvider credentialsProvider;
        private String region;

        private Builder() {
        }

        public Builder credentials(AWSCredentialsProvider credentialsProvider) {
            this.credentialsProvider = credentialsProvider;
            return this;
        }

        public Builder region(Region region) {
            this.region = region.getName();
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            return this;
        }

        public RdsIamAuthTokenGenerator build() {
            return new RdsIamAuthTokenGenerator(this.credentialsProvider, this.region);
        }
    }
}

