/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.OptionSetting;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class OptionConfiguration
implements Serializable,
Cloneable {
    private String optionName;
    private Integer port;
    private String optionVersion;
    private SdkInternalList<String> dBSecurityGroupMemberships;
    private SdkInternalList<String> vpcSecurityGroupMemberships;
    private SdkInternalList<OptionSetting> optionSettings;

    public void setOptionName(String optionName) {
        this.optionName = optionName;
    }

    public String getOptionName() {
        return this.optionName;
    }

    public OptionConfiguration withOptionName(String optionName) {
        this.setOptionName(optionName);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public OptionConfiguration withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setOptionVersion(String optionVersion) {
        this.optionVersion = optionVersion;
    }

    public String getOptionVersion() {
        return this.optionVersion;
    }

    public OptionConfiguration withOptionVersion(String optionVersion) {
        this.setOptionVersion(optionVersion);
        return this;
    }

    public List<String> getDBSecurityGroupMemberships() {
        if (this.dBSecurityGroupMemberships == null) {
            this.dBSecurityGroupMemberships = new SdkInternalList();
        }
        return this.dBSecurityGroupMemberships;
    }

    public void setDBSecurityGroupMemberships(Collection<String> dBSecurityGroupMemberships) {
        if (dBSecurityGroupMemberships == null) {
            this.dBSecurityGroupMemberships = null;
            return;
        }
        this.dBSecurityGroupMemberships = new SdkInternalList(dBSecurityGroupMemberships);
    }

    public OptionConfiguration withDBSecurityGroupMemberships(String ... dBSecurityGroupMemberships) {
        if (this.dBSecurityGroupMemberships == null) {
            this.setDBSecurityGroupMemberships((Collection<String>)new SdkInternalList(dBSecurityGroupMemberships.length));
        }
        for (String ele : dBSecurityGroupMemberships) {
            this.dBSecurityGroupMemberships.add((Object)ele);
        }
        return this;
    }

    public OptionConfiguration withDBSecurityGroupMemberships(Collection<String> dBSecurityGroupMemberships) {
        this.setDBSecurityGroupMemberships(dBSecurityGroupMemberships);
        return this;
    }

    public List<String> getVpcSecurityGroupMemberships() {
        if (this.vpcSecurityGroupMemberships == null) {
            this.vpcSecurityGroupMemberships = new SdkInternalList();
        }
        return this.vpcSecurityGroupMemberships;
    }

    public void setVpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships) {
        if (vpcSecurityGroupMemberships == null) {
            this.vpcSecurityGroupMemberships = null;
            return;
        }
        this.vpcSecurityGroupMemberships = new SdkInternalList(vpcSecurityGroupMemberships);
    }

    public OptionConfiguration withVpcSecurityGroupMemberships(String ... vpcSecurityGroupMemberships) {
        if (this.vpcSecurityGroupMemberships == null) {
            this.setVpcSecurityGroupMemberships((Collection<String>)new SdkInternalList(vpcSecurityGroupMemberships.length));
        }
        for (String ele : vpcSecurityGroupMemberships) {
            this.vpcSecurityGroupMemberships.add((Object)ele);
        }
        return this;
    }

    public OptionConfiguration withVpcSecurityGroupMemberships(Collection<String> vpcSecurityGroupMemberships) {
        this.setVpcSecurityGroupMemberships(vpcSecurityGroupMemberships);
        return this;
    }

    public List<OptionSetting> getOptionSettings() {
        if (this.optionSettings == null) {
            this.optionSettings = new SdkInternalList();
        }
        return this.optionSettings;
    }

    public void setOptionSettings(Collection<OptionSetting> optionSettings) {
        if (optionSettings == null) {
            this.optionSettings = null;
            return;
        }
        this.optionSettings = new SdkInternalList(optionSettings);
    }

    public OptionConfiguration withOptionSettings(OptionSetting ... optionSettings) {
        if (this.optionSettings == null) {
            this.setOptionSettings((Collection<OptionSetting>)new SdkInternalList(optionSettings.length));
        }
        for (OptionSetting ele : optionSettings) {
            this.optionSettings.add((Object)ele);
        }
        return this;
    }

    public OptionConfiguration withOptionSettings(Collection<OptionSetting> optionSettings) {
        this.setOptionSettings(optionSettings);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOptionName() != null) {
            sb.append("OptionName: ").append(this.getOptionName()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getOptionVersion() != null) {
            sb.append("OptionVersion: ").append(this.getOptionVersion()).append(",");
        }
        if (this.getDBSecurityGroupMemberships() != null) {
            sb.append("DBSecurityGroupMemberships: ").append(this.getDBSecurityGroupMemberships()).append(",");
        }
        if (this.getVpcSecurityGroupMemberships() != null) {
            sb.append("VpcSecurityGroupMemberships: ").append(this.getVpcSecurityGroupMemberships()).append(",");
        }
        if (this.getOptionSettings() != null) {
            sb.append("OptionSettings: ").append(this.getOptionSettings());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionConfiguration)) {
            return false;
        }
        OptionConfiguration other = (OptionConfiguration)obj;
        if (other.getOptionName() == null ^ this.getOptionName() == null) {
            return false;
        }
        if (other.getOptionName() != null && !other.getOptionName().equals(this.getOptionName())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getOptionVersion() == null ^ this.getOptionVersion() == null) {
            return false;
        }
        if (other.getOptionVersion() != null && !other.getOptionVersion().equals(this.getOptionVersion())) {
            return false;
        }
        if (other.getDBSecurityGroupMemberships() == null ^ this.getDBSecurityGroupMemberships() == null) {
            return false;
        }
        if (other.getDBSecurityGroupMemberships() != null && !other.getDBSecurityGroupMemberships().equals(this.getDBSecurityGroupMemberships())) {
            return false;
        }
        if (other.getVpcSecurityGroupMemberships() == null ^ this.getVpcSecurityGroupMemberships() == null) {
            return false;
        }
        if (other.getVpcSecurityGroupMemberships() != null && !other.getVpcSecurityGroupMemberships().equals(this.getVpcSecurityGroupMemberships())) {
            return false;
        }
        if (other.getOptionSettings() == null ^ this.getOptionSettings() == null) {
            return false;
        }
        return other.getOptionSettings() == null || other.getOptionSettings().equals(this.getOptionSettings());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOptionName() == null ? 0 : this.getOptionName().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getOptionVersion() == null ? 0 : this.getOptionVersion().hashCode());
        hashCode = 31 * hashCode + (this.getDBSecurityGroupMemberships() == null ? 0 : this.getDBSecurityGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getVpcSecurityGroupMemberships() == null ? 0 : this.getVpcSecurityGroupMemberships().hashCode());
        hashCode = 31 * hashCode + (this.getOptionSettings() == null ? 0 : this.getOptionSettings().hashCode());
        return hashCode;
    }

    public OptionConfiguration clone() {
        try {
            return (OptionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

