/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.kafka;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.data.input.kafka.KafkaTopicPartition;
import org.apache.druid.indexing.seekablestream.SeekableStreamSequenceNumbers;
import org.apache.druid.indexing.seekablestream.SeekableStreamStartSequenceNumbers;
import org.apache.druid.utils.CollectionUtils;

@JsonTypeName(value="start")
public class KafkaSeekableStreamStartSequenceNumbers
extends SeekableStreamStartSequenceNumbers<KafkaTopicPartition, Long> {
    private final boolean isMultiTopicPartition;

    public KafkaSeekableStreamStartSequenceNumbers(String stream, String topic, Map<KafkaTopicPartition, Long> partitionSequenceNumberMap, Map<KafkaTopicPartition, Long> partitionOffsetMap, @Nullable Set<KafkaTopicPartition> exclusivePartitions) {
        super(stream, topic, partitionSequenceNumberMap, partitionOffsetMap, exclusivePartitions);
        this.isMultiTopicPartition = !partitionSequenceNumberMap.isEmpty() && ((KafkaTopicPartition)partitionSequenceNumberMap.keySet().stream().findFirst().get()).isMultiTopicPartition();
    }

    public boolean isMultiTopicPartition() {
        return this.isMultiTopicPartition;
    }

    public SeekableStreamSequenceNumbers<KafkaTopicPartition, Long> plus(SeekableStreamSequenceNumbers<KafkaTopicPartition, Long> other) {
        Map<KafkaTopicPartition, Long> newMap;
        this.validateSequenceNumbersBaseType(other);
        KafkaSeekableStreamStartSequenceNumbers that = (KafkaSeekableStreamStartSequenceNumbers)other;
        if (!this.isMultiTopicPartition() && !that.isMultiTopicPartition()) {
            return super.plus(other);
        }
        String thisTopic = this.getStream();
        String thatTopic = that.getStream();
        HashSet newExclusivePartitions = new HashSet();
        if (!this.isMultiTopicPartition()) {
            newMap = new HashMap(this.getPartitionSequenceNumberMap());
            newMap.putAll(that.getPartitionSequenceNumberMap().entrySet().stream().filter(e -> {
                if (((KafkaTopicPartition)e.getKey()).topic().isPresent()) {
                    return ((KafkaTopicPartition)e.getKey()).topic().get().equals(thisTopic);
                }
                return thatTopic.equals(thisTopic);
            }).collect(Collectors.toMap(e -> new KafkaTopicPartition(false, thisTopic, ((KafkaTopicPartition)e.getKey()).partition()), Map.Entry::getValue)));
            this.getPartitionSequenceNumberMap().forEach((partitionId, sequenceOffset) -> {
                KafkaTopicPartition multiTopicPartitonIdToSearch = new KafkaTopicPartition(true, thisTopic, partitionId.partition());
                if (this.getExclusivePartitions().contains(partitionId) && !that.getPartitionSequenceNumberMap().containsKey(multiTopicPartitonIdToSearch)) {
                    newExclusivePartitions.add(new KafkaTopicPartition(false, this.getStream(), partitionId.partition()));
                }
            });
            newExclusivePartitions.addAll(that.getExclusivePartitions());
        } else {
            newMap = CollectionUtils.mapKeys((Map)this.getPartitionSequenceNumberMap(), k -> new KafkaTopicPartition(true, k.asTopicPartition(thisTopic).topic(), k.partition()));
            Pattern pattern = Pattern.compile(thisTopic);
            newMap.putAll(that.getPartitionSequenceNumberMap().entrySet().stream().filter(e -> {
                if (((KafkaTopicPartition)e.getKey()).topic().isPresent()) {
                    return pattern.matcher(((KafkaTopicPartition)e.getKey()).topic().get()).matches();
                }
                return pattern.matcher(thatTopic).matches();
            }).collect(Collectors.toMap(e -> new KafkaTopicPartition(true, ((KafkaTopicPartition)e.getKey()).asTopicPartition(thatTopic).topic(), ((KafkaTopicPartition)e.getKey()).partition()), Map.Entry::getValue)));
            this.getPartitionSequenceNumberMap().forEach((partitionId, sequenceOffset) -> {
                boolean thatTopicMatchesThisTopicPattern;
                KafkaTopicPartition multiTopicPartitonIdToSearch = new KafkaTopicPartition(true, thisTopic, partitionId.partition());
                boolean bl = thatTopicMatchesThisTopicPattern = partitionId.topic().isPresent() ? pattern.matcher(partitionId.topic().get()).matches() : pattern.matcher(thatTopic).matches();
                if (!(!this.getExclusivePartitions().contains(partitionId) || thatTopicMatchesThisTopicPattern && that.getPartitionSequenceNumberMap().containsKey(multiTopicPartitonIdToSearch))) {
                    newExclusivePartitions.add(new KafkaTopicPartition(true, this.getStream(), partitionId.partition()));
                }
            });
            newExclusivePartitions.addAll(that.getExclusivePartitions());
        }
        return new SeekableStreamStartSequenceNumbers(this.getStream(), newMap, newExclusivePartitions);
    }

    public SeekableStreamSequenceNumbers<KafkaTopicPartition, Long> minus(SeekableStreamSequenceNumbers<KafkaTopicPartition, Long> other) {
        this.validateSequenceNumbersBaseType(other);
        KafkaSeekableStreamStartSequenceNumbers otherStart = (KafkaSeekableStreamStartSequenceNumbers)other;
        if (!this.isMultiTopicPartition() && !otherStart.isMultiTopicPartition()) {
            return super.minus(other);
        }
        HashMap<KafkaTopicPartition, Long> newMap = new HashMap<KafkaTopicPartition, Long>();
        HashSet<KafkaTopicPartition> newExclusivePartitions = new HashSet<KafkaTopicPartition>();
        String thatTopic = otherStart.getStream();
        for (Map.Entry entry : this.getPartitionSequenceNumberMap().entrySet()) {
            boolean otherContainsThisSingleTopic;
            String thisTopic = ((KafkaTopicPartition)entry.getKey()).asTopicPartition(this.getStream()).topic();
            boolean otherContainsThis = otherStart.getPartitionSequenceNumberMap().containsKey(entry.getKey());
            boolean otherContainsThisMultiTopic = otherStart.getPartitionSequenceNumberMap().containsKey(new KafkaTopicPartition(true, thisTopic, ((KafkaTopicPartition)entry.getKey()).partition()));
            boolean bl = otherContainsThisSingleTopic = thatTopic.equals(thisTopic) && otherStart.getPartitionSequenceNumberMap().containsKey(new KafkaTopicPartition(false, null, ((KafkaTopicPartition)entry.getKey()).partition()));
            if (otherContainsThis || otherContainsThisMultiTopic || otherContainsThisSingleTopic) continue;
            newMap.put((KafkaTopicPartition)entry.getKey(), (Long)entry.getValue());
            if (!this.getExclusivePartitions().contains(entry.getKey())) continue;
            newExclusivePartitions.add((KafkaTopicPartition)entry.getKey());
        }
        return new SeekableStreamStartSequenceNumbers(this.getStream(), newMap, newExclusivePartitions);
    }
}

