/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.audit;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.DeleteObjectRequest;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetBucketLocationRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.ListMultipartUploadsRequest;
import com.amazonaws.services.s3.model.ListNextBatchOfObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.SelectObjectContentRequest;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.util.List;

public class AWSRequestAnalyzer {
    public <T extends AmazonWebServiceRequest> RequestInfo analyze(T request) {
        if (request instanceof AbortMultipartUploadRequest) {
            return this.writing("multipart_upload_aborted", ((AbortMultipartUploadRequest)request).getKey(), 0);
        }
        if (request instanceof CompleteMultipartUploadRequest) {
            CompleteMultipartUploadRequest r = (CompleteMultipartUploadRequest)request;
            return this.writing("multipart_upload_completed", r.getKey(), r.getPartETags().size());
        }
        if (request instanceof DeleteObjectRequest) {
            return this.writing("object_delete_request", ((DeleteObjectRequest)request).getKey(), 1);
        }
        if (request instanceof DeleteObjectsRequest) {
            DeleteObjectsRequest r = (DeleteObjectsRequest)request;
            List keys = r.getKeys();
            return this.writing("object_bulk_delete_request", keys.isEmpty() ? null : ((DeleteObjectsRequest.KeyVersion)keys.get(0)).getKey(), keys.size());
        }
        if (request instanceof GetBucketLocationRequest) {
            GetBucketLocationRequest r = (GetBucketLocationRequest)request;
            return this.reading("store_exists_probe", r.getBucketName(), 0);
        }
        if (request instanceof GetObjectMetadataRequest) {
            return this.reading("action_http_head_request", ((GetObjectMetadataRequest)request).getKey(), 0);
        }
        if (request instanceof GetObjectRequest) {
            GetObjectRequest r = (GetObjectRequest)request;
            long[] range = r.getRange();
            long size = range == null ? -1L : range[1] - range[0];
            return this.reading("action_http_get_request", r.getKey(), size);
        }
        if (request instanceof InitiateMultipartUploadRequest) {
            return this.writing("multipart_upload_started", ((InitiateMultipartUploadRequest)request).getKey(), 0);
        }
        if (request instanceof ListMultipartUploadsRequest) {
            ListMultipartUploadsRequest r = (ListMultipartUploadsRequest)request;
            return this.reading("multipart_upload_list", r.getPrefix(), r.getMaxUploads());
        }
        if (request instanceof ListObjectsRequest) {
            ListObjectsRequest r = (ListObjectsRequest)request;
            return this.reading("object_list_request", r.getPrefix(), r.getMaxKeys());
        }
        if (request instanceof ListNextBatchOfObjectsRequest) {
            ListNextBatchOfObjectsRequest r = (ListNextBatchOfObjectsRequest)request;
            ObjectListing l = r.getPreviousObjectListing();
            String prefix = "";
            int size = 0;
            if (l != null) {
                prefix = l.getPrefix();
                size = l.getMaxKeys();
            }
            return this.reading("object_list_request", prefix, size);
        }
        if (request instanceof ListObjectsV2Request) {
            ListObjectsV2Request r = (ListObjectsV2Request)request;
            return this.reading("object_list_request", r.getPrefix(), r.getMaxKeys());
        }
        if (request instanceof PutObjectRequest) {
            PutObjectRequest r = (PutObjectRequest)request;
            return this.writing("object_put_request", r.getKey(), 0);
        }
        if (request instanceof SelectObjectContentRequest) {
            SelectObjectContentRequest r = (SelectObjectContentRequest)request;
            return this.reading("object_select_requests", r.getKey(), 1);
        }
        if (request instanceof UploadPartRequest) {
            UploadPartRequest r = (UploadPartRequest)request;
            return this.writing("multipart_upload_part_put", r.getKey(), r.getPartSize());
        }
        return this.writing(request.getClass().getName(), null, 0);
    }

    private RequestInfo request(String verb, boolean mutating, String key, Number size) {
        return new RequestInfo(verb, mutating, key, size);
    }

    private RequestInfo reading(String verb, String key, Number size) {
        return this.request(verb, false, key, size);
    }

    private RequestInfo writing(String verb, String key, Number size) {
        return this.request(verb, true, key, size);
    }

    public static boolean isRequestNotAlwaysInSpan(Object request) {
        return request instanceof CopyPartRequest || request instanceof CompleteMultipartUploadRequest || request instanceof GetBucketLocationRequest;
    }

    public static boolean isRequestMultipartIO(Object request) {
        return request instanceof CopyPartRequest || request instanceof CompleteMultipartUploadRequest || request instanceof InitiateMultipartUploadRequest || request instanceof UploadPartRequest;
    }

    private static long toSafeLong(Number size) {
        return size != null ? size.longValue() : 0L;
    }

    public static final class RequestInfo {
        private String verb;
        private boolean mutating;
        private String key;
        private long size;

        private RequestInfo(String verb, boolean mutating, String key, Number size) {
            this.verb = verb;
            this.mutating = mutating;
            this.key = key;
            this.size = AWSRequestAnalyzer.toSafeLong(size);
        }

        public String getVerb() {
            return this.verb;
        }

        public boolean isMutating() {
            return this.mutating;
        }

        public String getKey() {
            return this.key;
        }

        public long getSize() {
            return this.size;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            sb.append(this.verb);
            if (this.key != null) {
                sb.append(" '").append(this.key).append('\'');
            }
            sb.append(" size=").append(this.size);
            sb.append(", mutating=").append(this.mutating);
            sb.append('}');
            return sb.toString();
        }
    }
}

