/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.CpuOptions;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CpuOptionsStaxUnmarshaller
implements Unmarshaller<CpuOptions, StaxUnmarshallerContext> {
    private static CpuOptionsStaxUnmarshaller instance;

    public CpuOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        CpuOptions cpuOptions = new CpuOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cpuOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("coreCount", targetDepth)) {
                    cpuOptions.setCoreCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("threadsPerCore", targetDepth)) {
                    cpuOptions.setThreadsPerCore(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("amdSevSnp", targetDepth)) continue;
                cpuOptions.setAmdSevSnp(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cpuOptions;
    }

    public static CpuOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CpuOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

