/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupRulesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSecurityGroupRulesRequestMarshaller
implements Marshaller<Request<DescribeSecurityGroupRulesRequest>, DescribeSecurityGroupRulesRequest> {
    public Request<DescribeSecurityGroupRulesRequest> marshall(DescribeSecurityGroupRulesRequest describeSecurityGroupRulesRequest) {
        SdkInternalList describeSecurityGroupRulesRequestSecurityGroupRuleIdsList;
        if (describeSecurityGroupRulesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSecurityGroupRulesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSecurityGroupRules");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeSecurityGroupRulesRequestFiltersList = (SdkInternalList)describeSecurityGroupRulesRequest.getFilters();
        if (!describeSecurityGroupRulesRequestFiltersList.isEmpty() || !describeSecurityGroupRulesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeSecurityGroupRulesRequestFiltersListValue : describeSecurityGroupRulesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeSecurityGroupRulesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeSecurityGroupRulesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeSecurityGroupRulesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeSecurityGroupRulesRequestSecurityGroupRuleIdsList = (SdkInternalList)describeSecurityGroupRulesRequest.getSecurityGroupRuleIds()).isEmpty() || !describeSecurityGroupRulesRequestSecurityGroupRuleIdsList.isAutoConstruct()) {
            int securityGroupRuleIdsListIndex = 1;
            for (String describeSecurityGroupRulesRequestSecurityGroupRuleIdsListValue : describeSecurityGroupRulesRequestSecurityGroupRuleIdsList) {
                if (describeSecurityGroupRulesRequestSecurityGroupRuleIdsListValue != null) {
                    request.addParameter("SecurityGroupRuleId." + securityGroupRuleIdsListIndex, StringUtils.fromString((String)describeSecurityGroupRulesRequestSecurityGroupRuleIdsListValue));
                }
                ++securityGroupRuleIdsListIndex;
            }
        }
        if (describeSecurityGroupRulesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSecurityGroupRulesRequest.getNextToken()));
        }
        if (describeSecurityGroupRulesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSecurityGroupRulesRequest.getMaxResults()));
        }
        return request;
    }
}

