/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.RegisterInstanceEventNotificationAttributesRequest;
import com.amazonaws.services.ec2.model.RegisterInstanceTagAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RegisterInstanceEventNotificationAttributesRequestMarshaller
implements Marshaller<Request<RegisterInstanceEventNotificationAttributesRequest>, RegisterInstanceEventNotificationAttributesRequest> {
    public Request<RegisterInstanceEventNotificationAttributesRequest> marshall(RegisterInstanceEventNotificationAttributesRequest registerInstanceEventNotificationAttributesRequest) {
        if (registerInstanceEventNotificationAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)registerInstanceEventNotificationAttributesRequest, "AmazonEC2");
        request.addParameter("Action", "RegisterInstanceEventNotificationAttributes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        RegisterInstanceTagAttributeRequest instanceTagAttribute = registerInstanceEventNotificationAttributesRequest.getInstanceTagAttribute();
        if (instanceTagAttribute != null) {
            SdkInternalList registerInstanceTagAttributeRequestInstanceTagKeysList;
            if (instanceTagAttribute.getIncludeAllTagsOfInstance() != null) {
                request.addParameter("InstanceTagAttribute.IncludeAllTagsOfInstance", StringUtils.fromBoolean((Boolean)instanceTagAttribute.getIncludeAllTagsOfInstance()));
            }
            if (!(registerInstanceTagAttributeRequestInstanceTagKeysList = (SdkInternalList)instanceTagAttribute.getInstanceTagKeys()).isEmpty() || !registerInstanceTagAttributeRequestInstanceTagKeysList.isAutoConstruct()) {
                int instanceTagKeysListIndex = 1;
                for (String registerInstanceTagAttributeRequestInstanceTagKeysListValue : registerInstanceTagAttributeRequestInstanceTagKeysList) {
                    if (registerInstanceTagAttributeRequestInstanceTagKeysListValue != null) {
                        request.addParameter("InstanceTagAttribute.InstanceTagKey." + instanceTagKeysListIndex, StringUtils.fromString((String)registerInstanceTagAttributeRequestInstanceTagKeysListValue));
                    }
                    ++instanceTagKeysListIndex;
                }
            }
        }
        return request;
    }
}

