/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.lookup.cache.loading;

import com.google.common.base.Preconditions;

public class LookupCacheStats {
    private final long hitCount;
    private final long missCount;
    private final long evictionCount;

    public LookupCacheStats(long hitCount, long missCount, long evictionCount) {
        Preconditions.checkArgument((hitCount >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((missCount >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((evictionCount >= 0L ? 1 : 0) != 0);
        this.hitCount = hitCount;
        this.missCount = missCount;
        this.evictionCount = evictionCount;
    }

    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    public long hitCount() {
        return this.hitCount;
    }

    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public long missCount() {
        return this.missCount;
    }

    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    public long evictionCount() {
        return this.evictionCount;
    }

    public LookupCacheStats minus(LookupCacheStats other) {
        return new LookupCacheStats(Math.max(0L, this.hitCount - other.hitCount), Math.max(0L, this.missCount - other.missCount), Math.max(0L, this.evictionCount - other.evictionCount));
    }

    public LookupCacheStats plus(LookupCacheStats other) {
        return new LookupCacheStats(this.hitCount + other.hitCount, this.missCount + other.missCount, this.evictionCount + other.evictionCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LookupCacheStats)) {
            return false;
        }
        LookupCacheStats that = (LookupCacheStats)o;
        if (this.hitCount != that.hitCount) {
            return false;
        }
        if (this.missCount != that.missCount) {
            return false;
        }
        return this.evictionCount == that.evictionCount;
    }

    public int hashCode() {
        int result = (int)(this.hitCount ^ this.hitCount >>> 32);
        result = 31 * result + (int)(this.missCount ^ this.missCount >>> 32);
        result = 31 * result + (int)(this.evictionCount ^ this.evictionCount >>> 32);
        return result;
    }

    public String toString() {
        return "LookupCacheStats{hitCount=" + this.hitCount + ", missCount=" + this.missCount + ", evictionCount=" + this.evictionCount + '}';
    }
}

