/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.azure;

import com.azure.storage.blob.models.BlobStorageException;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.azure.AzureEntity;
import org.apache.druid.data.input.azure.AzureEntityFactory;
import org.apache.druid.data.input.azure.AzureStorageAccountInputSourceConfig;
import org.apache.druid.data.input.impl.CloudObjectInputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.CloudObjectSplitWidget;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureCloudBlobIterableFactory;
import org.apache.druid.storage.azure.AzureIngestClientFactory;
import org.apache.druid.storage.azure.AzureInputDataConfig;
import org.apache.druid.storage.azure.AzureStorage;

public class AzureStorageAccountInputSource
extends CloudObjectInputSource {
    public static final String SCHEME = "azureStorage";
    private final AzureEntityFactory entityFactory;
    private final AzureCloudBlobIterableFactory azureCloudBlobIterableFactory;
    private final AzureInputDataConfig inputDataConfig;
    private final AzureStorageAccountInputSourceConfig azureStorageAccountInputSourceConfig;
    private final AzureAccountConfig azureAccountConfig;
    private final AzureIngestClientFactory azureIngestClientFactory;

    @JsonCreator
    public AzureStorageAccountInputSource(@JacksonInject AzureEntityFactory entityFactory, @JacksonInject AzureCloudBlobIterableFactory azureCloudBlobIterableFactory, @JacksonInject AzureInputDataConfig inputDataConfig, @JacksonInject AzureAccountConfig azureAccountConfig, @JsonProperty(value="uris") @Nullable List<URI> uris, @JsonProperty(value="prefixes") @Nullable List<URI> prefixes, @JsonProperty(value="objects") @Nullable List<CloudObjectLocation> objects, @JsonProperty(value="objectGlob") @Nullable String objectGlob, @JsonProperty(value="properties") @Nullable AzureStorageAccountInputSourceConfig azureStorageAccountInputSourceConfig, @JsonProperty(value="systemFields") @Nullable SystemFields systemFields) {
        super(SCHEME, uris, prefixes, objects, objectGlob, systemFields);
        this.entityFactory = (AzureEntityFactory)Preconditions.checkNotNull((Object)entityFactory, (Object)"AzureEntityFactory");
        this.azureCloudBlobIterableFactory = (AzureCloudBlobIterableFactory)Preconditions.checkNotNull((Object)azureCloudBlobIterableFactory, (Object)"AzureCloudBlobIterableFactory");
        this.inputDataConfig = (AzureInputDataConfig)Preconditions.checkNotNull((Object)inputDataConfig, (Object)"AzureInputDataConfig");
        this.azureStorageAccountInputSourceConfig = azureStorageAccountInputSourceConfig;
        this.azureAccountConfig = azureAccountConfig;
        this.azureIngestClientFactory = new AzureIngestClientFactory(azureAccountConfig, azureStorageAccountInputSourceConfig);
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return Collections.singleton(SCHEME);
    }

    public SplittableInputSource<List<CloudObjectLocation>> withSplit(InputSplit<List<CloudObjectLocation>> split) {
        return new AzureStorageAccountInputSource(this.entityFactory, this.azureCloudBlobIterableFactory, this.inputDataConfig, this.azureAccountConfig, null, null, (List)split.get(), this.getObjectGlob(), this.azureStorageAccountInputSourceConfig, this.systemFields);
    }

    public Object getSystemFieldValue(InputEntity entity, SystemField field) {
        AzureEntity azureEntity = (AzureEntity)entity;
        switch (field) {
            case URI: {
                return azureEntity.getUri().toString();
            }
            case BUCKET: {
                return azureEntity.getLocation().getBucket();
            }
            case PATH: {
                return azureEntity.getLocation().getPath();
            }
        }
        return null;
    }

    protected AzureEntity createEntity(CloudObjectLocation location) {
        return this.entityFactory.create(location, new AzureStorage(this.azureIngestClientFactory, location.getBucket()), SCHEME);
    }

    protected CloudObjectSplitWidget getSplitWidget() {
        class SplitWidget
        implements CloudObjectSplitWidget {
            SplitWidget() {
            }

            public Iterator<CloudObjectSplitWidget.LocationWithSize> getDescriptorIteratorForPrefixes(List<URI> prefixes) {
                return Iterators.transform(AzureStorageAccountInputSource.this.azureCloudBlobIterableFactory.create(prefixes, AzureStorageAccountInputSource.this.inputDataConfig.getMaxListingLength(), new AzureStorage(AzureStorageAccountInputSource.this.azureIngestClientFactory, null)).iterator(), blob -> {
                    try {
                        return new CloudObjectSplitWidget.LocationWithSize(blob.getStorageAccount(), blob.getContainerName() + "/" + blob.getName(), blob.getBlobLength());
                    }
                    catch (BlobStorageException e) {
                        throw new RuntimeException(e);
                    }
                });
            }

            public long getObjectSize(CloudObjectLocation location) {
                try {
                    AzureStorage azureStorage = new AzureStorage(AzureStorageAccountInputSource.this.azureIngestClientFactory, location.getBucket());
                    Pair<String, String> locationInfo = AzureStorageAccountInputSource.getContainerAndPathFromObjectLocation(location);
                    return azureStorage.getBlockBlobLength((String)locationInfo.lhs, (String)locationInfo.rhs);
                }
                catch (BlobStorageException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return new SplitWidget();
    }

    @Nullable
    @JsonProperty(value="properties")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AzureStorageAccountInputSourceConfig getAzureStorageAccountInputSourceConfig() {
        return this.azureStorageAccountInputSourceConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureStorageAccountInputSource that = (AzureStorageAccountInputSource)((Object)o);
        return this.inputDataConfig.equals(that.inputDataConfig) && this.azureStorageAccountInputSourceConfig.equals(that.azureStorageAccountInputSourceConfig) && this.azureAccountConfig.equals(that.azureAccountConfig) && this.azureIngestClientFactory.equals(that.azureIngestClientFactory);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.inputDataConfig, this.azureStorageAccountInputSourceConfig, this.azureAccountConfig, this.azureIngestClientFactory);
    }

    public String toString() {
        return "AzureStorageAccountInputSource{uris=" + this.getUris() + ", prefixes=" + this.getPrefixes() + ", objects=" + this.getObjects() + ", objectGlob=" + this.getObjectGlob() + ", azureStorageAccountInputSourceConfig=" + this.getAzureStorageAccountInputSourceConfig() + (this.systemFields.getFields().isEmpty() ? "" : ", systemFields=" + this.systemFields) + '}';
    }

    public static Pair<String, String> getContainerAndPathFromObjectLocation(CloudObjectLocation location) {
        String[] pathParts = location.getPath().split("/", 2);
        return Pair.of((Object)pathParts[0], (Object)(pathParts.length == 2 ? pathParts[1] : ""));
    }
}

