/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.net.URI;
import java.util.Iterator;
import org.apache.druid.storage.azure.AzureCloudBlobIteratorFactory;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.blob.CloudBlobHolder;

public class AzureCloudBlobIterable
implements Iterable<CloudBlobHolder> {
    private final Iterable<URI> prefixes;
    private final int maxListingLength;
    private final AzureCloudBlobIteratorFactory azureCloudBlobIteratorFactory;
    private final AzureStorage azureStorage;

    @AssistedInject
    public AzureCloudBlobIterable(AzureCloudBlobIteratorFactory azureCloudBlobIteratorFactory, @Assisted Iterable<URI> prefixes, @Assisted int maxListingLength, @Assisted AzureStorage azureStorage) {
        this.azureCloudBlobIteratorFactory = azureCloudBlobIteratorFactory;
        this.prefixes = prefixes;
        this.maxListingLength = maxListingLength;
        this.azureStorage = azureStorage;
    }

    @Override
    public Iterator<CloudBlobHolder> iterator() {
        return this.azureCloudBlobIteratorFactory.create(this.prefixes, this.maxListingLength, this.azureStorage);
    }
}

