/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure;

import com.google.common.io.ByteSource;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.azure.AzureAccountConfig;
import org.apache.druid.storage.azure.AzureByteSource;
import org.apache.druid.storage.azure.AzureByteSourceFactory;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureUtils;
import org.apache.druid.utils.CompressionUtils;

public class AzureDataSegmentPuller {
    private static final Logger log = new Logger(AzureDataSegmentPuller.class);
    private final AzureByteSourceFactory byteSourceFactory;
    private final AzureStorage azureStorage;
    private final AzureAccountConfig azureAccountConfig;

    @Inject
    public AzureDataSegmentPuller(AzureByteSourceFactory byteSourceFactory, @Global AzureStorage azureStorage, AzureAccountConfig azureAccountConfig) {
        this.byteSourceFactory = byteSourceFactory;
        this.azureStorage = azureStorage;
        this.azureAccountConfig = azureAccountConfig;
    }

    FileUtils.FileCopyResult getSegmentFiles(String containerName, String blobPath, File outDir) throws SegmentLoadingException {
        try {
            FileUtils.mkdirp((File)outDir);
            log.info("Loading container: [%s], with blobPath: [%s] and outDir: [%s]", new Object[]{containerName, blobPath, outDir});
            String actualBlobPath = AzureUtils.maybeRemoveAzurePathPrefix(blobPath, this.azureAccountConfig.getBlobStorageEndpoint());
            AzureByteSource byteSource = this.byteSourceFactory.create(containerName, actualBlobPath, this.azureStorage);
            FileUtils.FileCopyResult result = CompressionUtils.unzip((ByteSource)byteSource, (File)outDir, AzureUtils.AZURE_RETRY, (boolean)false);
            log.info("Loaded %d bytes from [%s] to [%s]", new Object[]{result.size(), actualBlobPath, outDir.getAbsolutePath()});
            return result;
        }
        catch (IOException e) {
            try {
                FileUtils.deleteDirectory((File)outDir);
            }
            catch (IOException ioe) {
                log.warn((Throwable)ioe, "Failed to remove output directory [%s] for segment pulled from [%s]", new Object[]{outDir.getAbsolutePath(), blobPath});
            }
            throw new SegmentLoadingException((Throwable)e, e.getMessage(), new Object[0]);
        }
    }
}

