/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.LockGranularity;
import org.apache.druid.indexing.common.TaskLock;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.overlord.LockRequest;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TimeChunkLock
implements TaskLock {
    static final String TYPE = "timeChunk";
    private final TaskLockType lockType;
    private final String groupId;
    private final String dataSource;
    private final Interval interval;
    private final String version;
    @Nullable
    private final Integer priority;
    private final boolean revoked;

    @JsonCreator
    public TimeChunkLock(@JsonProperty(value="type") @Nullable TaskLockType lockType, @JsonProperty(value="groupId") String groupId, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="interval") Interval interval, @JsonProperty(value="version") String version, @JsonProperty(value="priority") @Nullable Integer priority, @JsonProperty(value="revoked") boolean revoked) {
        this.lockType = lockType == null ? TaskLockType.EXCLUSIVE : lockType;
        this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"groupId");
        this.dataSource = (String)Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        this.interval = (Interval)Preconditions.checkNotNull((Object)interval, (Object)"interval");
        this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version");
        this.priority = priority;
        this.revoked = revoked;
    }

    @VisibleForTesting
    public TimeChunkLock(TaskLockType type, String groupId, String dataSource, Interval interval, String version, int priority) {
        this(type, groupId, dataSource, interval, version, priority, false);
    }

    @Override
    public TaskLock revokedCopy() {
        return new TimeChunkLock(this.lockType, this.groupId, this.dataSource, this.interval, this.version, this.priority, true);
    }

    @Override
    public TaskLock withPriority(int priority) {
        return new TimeChunkLock(this.lockType, this.groupId, this.dataSource, this.interval, this.version, priority, this.revoked);
    }

    @Override
    public LockGranularity getGranularity() {
        return LockGranularity.TIME_CHUNK;
    }

    @Override
    @JsonProperty
    public TaskLockType getType() {
        return this.lockType;
    }

    @Override
    @JsonProperty
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getPriority() {
        return this.priority;
    }

    @Override
    public int getNonNullPriority() {
        return (Integer)Preconditions.checkNotNull((Object)this.priority, (Object)"priority");
    }

    @Override
    @JsonProperty
    public boolean isRevoked() {
        return this.revoked;
    }

    @Override
    public boolean conflict(LockRequest request) {
        return this.dataSource.equals(request.getDataSource()) && this.interval.overlaps((ReadableInterval)request.getInterval());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeChunkLock that = (TimeChunkLock)o;
        return this.revoked == that.revoked && this.lockType == that.lockType && Objects.equals(this.groupId, that.groupId) && Objects.equals(this.dataSource, that.dataSource) && Objects.equals(this.interval, that.interval) && Objects.equals(this.version, that.version) && Objects.equals(this.priority, that.priority);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.lockType, this.groupId, this.dataSource, this.interval, this.version, this.priority, this.revoked});
    }

    public String toString() {
        return "TimeChunkLock{type=" + (Object)((Object)this.lockType) + ", groupId='" + this.groupId + '\'' + ", dataSource='" + this.dataSource + '\'' + ", interval=" + this.interval + ", version='" + this.version + '\'' + ", priority=" + this.priority + ", revoked=" + this.revoked + '}';
    }
}

