/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import org.apache.druid.indexing.common.actions.SegmentAllocateAction;
import org.apache.druid.indexing.common.task.Task;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;

public class SegmentAllocateRequest {
    private final Task task;
    private final SegmentAllocateAction action;
    private final int maxAttempts;
    private final Interval rowInterval;
    private int attempts;

    public SegmentAllocateRequest(Task task, SegmentAllocateAction action, int maxAttempts) {
        this.task = task;
        this.action = action;
        this.maxAttempts = maxAttempts;
        this.rowInterval = action.getQueryGranularity().bucket(action.getTimestamp()).withChronology((Chronology)ISOChronology.getInstanceUTC());
    }

    public Task getTask() {
        return this.task;
    }

    public SegmentAllocateAction getAction() {
        return this.action;
    }

    public void incrementAttempts() {
        ++this.attempts;
    }

    public boolean canRetry() {
        return this.attempts < this.maxAttempts;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public Interval getRowInterval() {
        return this.rowInterval;
    }

    public String toString() {
        return "SegmentAllocateRequest{taskId=" + this.task.getId() + ", queryGranularity=" + this.action.getQueryGranularity() + ", segmentGranularity=" + this.action.getPreferredSegmentGranularity() + ", maxAttempts=" + this.maxAttempts + ", rowInterval=" + this.rowInterval + ", attempts=" + this.attempts + '}';
    }
}

