/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.druid.indexing.common.config.TaskConfig;

public class CurrentSubTaskHolder
implements Consumer<TaskConfig> {
    private static final Object SPECIAL_VALUE_STOPPED = new Object();
    private final AtomicReference<Object> currentSubTaskReference = new AtomicReference();
    private final BiConsumer<Object, TaskConfig> cleanFunction;

    public CurrentSubTaskHolder(BiConsumer<Object, TaskConfig> subTaskCleaner) {
        this.cleanFunction = subTaskCleaner;
    }

    public boolean setTask(Object subTask) {
        Object prevSpec = this.currentSubTaskReference.get();
        return prevSpec != SPECIAL_VALUE_STOPPED && this.currentSubTaskReference.compareAndSet(prevSpec, subTask);
    }

    public <T> T getTask() {
        return (T)this.currentSubTaskReference.get();
    }

    @Override
    public void accept(TaskConfig taskConfig) {
        Object currentSubTask = this.currentSubTaskReference.getAndSet(SPECIAL_VALUE_STOPPED);
        if (currentSubTask != null) {
            this.cleanFunction.accept(currentSubTask, taskConfig);
        }
    }
}

