/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.Rows;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.indexer.Checks;
import org.apache.druid.indexer.IngestionState;
import org.apache.druid.indexer.Property;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SecondaryPartitionType;
import org.apache.druid.indexer.report.TaskReport;
import org.apache.druid.indexing.common.TaskLockType;
import org.apache.druid.indexing.common.TaskRealtimeMetricsMonitorBuilder;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.stats.TaskRealtimeMetricsMonitor;
import org.apache.druid.indexing.common.task.AbstractBatchIndexTask;
import org.apache.druid.indexing.common.task.AbstractTask;
import org.apache.druid.indexing.common.task.BatchAppenderators;
import org.apache.druid.indexing.common.task.FilteringCloseableInputRowIterator;
import org.apache.druid.indexing.common.task.IndexTaskUtils;
import org.apache.druid.indexing.common.task.InputSourceProcessor;
import org.apache.druid.indexing.common.task.PendingSegmentAllocatingTask;
import org.apache.druid.indexing.common.task.SegmentAllocatorForBatch;
import org.apache.druid.indexing.common.task.SegmentAllocators;
import org.apache.druid.indexing.common.task.SequenceNameFunction;
import org.apache.druid.indexing.common.task.TaskResource;
import org.apache.druid.indexing.common.task.batch.parallel.PartialHashSegmentGenerateTask;
import org.apache.druid.indexing.common.task.batch.parallel.TombstoneHelper;
import org.apache.druid.indexing.common.task.batch.parallel.iterator.DefaultIndexTaskInputRowIteratorBuilder;
import org.apache.druid.indexing.common.task.batch.partition.CompletePartitionAnalysis;
import org.apache.druid.indexing.common.task.batch.partition.HashPartitionAnalysis;
import org.apache.druid.indexing.common.task.batch.partition.LinearPartitionAnalysis;
import org.apache.druid.indexing.common.task.batch.partition.PartitionAnalysis;
import org.apache.druid.indexing.input.DruidInputSource;
import org.apache.druid.indexing.input.TaskInputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.JodaUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.metrics.Monitor;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.SegmentSchemaMapping;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.ParseExceptionReport;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.incremental.RowIngestionMetersTotals;
import org.apache.druid.segment.indexing.BatchIOConfig;
import org.apache.druid.segment.indexing.DataSchema;
import org.apache.druid.segment.indexing.IOConfig;
import org.apache.druid.segment.indexing.IngestionSpec;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.indexing.granularity.ArbitraryGranularitySpec;
import org.apache.druid.segment.indexing.granularity.GranularitySpec;
import org.apache.druid.segment.realtime.ChatHandler;
import org.apache.druid.segment.realtime.SegmentGenerationMetrics;
import org.apache.druid.segment.realtime.appenderator.Appenderator;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.realtime.appenderator.BatchAppenderatorDriver;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.segment.realtime.appenderator.SegmentsAndCommitMetadata;
import org.apache.druid.segment.realtime.appenderator.TransactionalSegmentPublisher;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.utils.CircularBuffer;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.joda.time.Interval;
import org.joda.time.Period;

public class IndexTask
extends AbstractBatchIndexTask
implements ChatHandler,
PendingSegmentAllocatingTask {
    public static final HashFunction HASH_FUNCTION = Hashing.murmur3_128();
    public static final String TYPE = "index";
    private static final Logger log = new Logger(IndexTask.class);
    private final String baseSequenceName;
    private final IndexIngestionSpec ingestionSchema;
    private IngestionState ingestionState;
    private boolean isStandAloneTask;
    private @MonotonicNonNull ParseExceptionHandler determinePartitionsParseExceptionHandler;
    private @MonotonicNonNull ParseExceptionHandler buildSegmentsParseExceptionHandler;
    private @MonotonicNonNull AuthorizerMapper authorizerMapper;
    private @MonotonicNonNull RowIngestionMeters determinePartitionsMeters;
    private @MonotonicNonNull RowIngestionMeters buildSegmentsMeters;
    @Nullable
    private String errorMsg;
    private TaskReport.ReportMap completionReports;

    private static String makeGroupId(IndexIngestionSpec ingestionSchema, AbstractTask.IngestionMode ingestionMode) {
        return IndexTask.makeGroupId(ingestionSchema.dataSchema.getDataSource(), ingestionMode);
    }

    private static String makeGroupId(String dataSource, AbstractTask.IngestionMode ingestionMode) {
        if (ingestionMode == AbstractTask.IngestionMode.APPEND) {
            return StringUtils.format((String)"%s_append_%s", (Object[])new Object[]{TYPE, dataSource});
        }
        return null;
    }

    @JsonCreator
    public IndexTask(@JsonProperty(value="id") String id, @JsonProperty(value="resource") TaskResource taskResource, @JsonProperty(value="spec") IndexIngestionSpec ingestionSchema, @JsonProperty(value="context") Map<String, Object> context) {
        this(id, IndexTask.makeGroupId(ingestionSchema, IndexTask.computeBatchIngestionMode(ingestionSchema.getIOConfig())), taskResource, ingestionSchema.dataSchema.getDataSource(), null, ingestionSchema, context, -1, true);
    }

    public IndexTask(String id, String groupId, TaskResource resource, String dataSource, @Nullable String baseSequenceName, IndexIngestionSpec ingestionSchema, Map<String, Object> context, int maxAllowedLockCount, boolean isStandAloneTask) {
        super(IndexTask.getOrMakeId(id, TYPE, dataSource), groupId, resource, dataSource, context, maxAllowedLockCount, IndexTask.computeBatchIngestionMode(ingestionSchema.getIOConfig()));
        this.baseSequenceName = baseSequenceName == null ? this.getId() : baseSequenceName;
        this.ingestionSchema = ingestionSchema;
        this.ingestionState = IngestionState.NOT_STARTED;
        this.isStandAloneTask = isStandAloneTask;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isReady(TaskActionClient taskActionClient) throws Exception {
        IndexTuningConfig tuningConfig = this.getIngestionSchema().getTuningConfig();
        if (tuningConfig != null && tuningConfig.getPartitionsSpec() != null && tuningConfig.getPartitionsSpec().getType() != SecondaryPartitionType.LINEAR && tuningConfig.getPartitionsSpec().getType() != SecondaryPartitionType.HASH) {
            throw new UOE("partitionsSpec[%s] is not supported", new Object[]{tuningConfig.getPartitionsSpec().getClass().getName()});
        }
        return this.determineLockGranularityAndTryLock(taskActionClient, this.ingestionSchema.dataSchema.getGranularitySpec().inputIntervals());
    }

    @Override
    public boolean requireLockExistingSegments() {
        return IndexTask.isGuaranteedRollup(this.getIngestionMode(), this.ingestionSchema.tuningConfig) || this.getIngestionMode() != AbstractTask.IngestionMode.APPEND;
    }

    @Override
    public List<DataSegment> findSegmentsToLock(TaskActionClient taskActionClient, List<Interval> intervals) throws IOException {
        return IndexTask.findInputSegments(this.getDataSource(), taskActionClient, intervals);
    }

    @Override
    public boolean isPerfectRollup() {
        return IndexTask.isGuaranteedRollup(this.getIngestionMode(), this.ingestionSchema.tuningConfig);
    }

    @Override
    @Nullable
    public Granularity getSegmentGranularity() {
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        if (granularitySpec instanceof ArbitraryGranularitySpec) {
            return null;
        }
        return granularitySpec.getSegmentGranularity();
    }

    @Override
    public String getTaskAllocatorId() {
        return this.getGroupId();
    }

    @Override
    @Nonnull
    @JsonIgnore
    public Set<ResourceAction> getInputSourceResources() {
        return this.getIngestionSchema().getIOConfig().getInputSource() != null ? this.getIngestionSchema().getIOConfig().getInputSource().getTypes().stream().map(i -> new ResourceAction(new Resource(i, "EXTERNAL"), Action.READ)).collect(Collectors.toSet()) : ImmutableSet.of();
    }

    @Nullable
    @JsonIgnore
    public TaskReport.ReportMap getCompletionReports() {
        return this.completionReports;
    }

    @GET
    @Path(value="/unparseableEvents")
    @Produces(value={"application/json"})
    public Response getUnparseableEvents(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        return Response.ok(this.doGetUnparseableEvents(full != null)).build();
    }

    public Map<String, Object> doGetUnparseableEvents(boolean isFullReport) {
        HashMap<String, Object> events = new HashMap<String, Object>();
        if (IndexTask.addDeterminePartitionStatsToReport(isFullReport, this.ingestionState)) {
            events.put("determinePartitions", IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)this.determinePartitionsParseExceptionHandler.getSavedParseExceptionReports()));
        }
        if (IndexTask.addBuildSegmentStatsToReport(isFullReport, this.ingestionState)) {
            events.put("buildSegments", IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)this.buildSegmentsParseExceptionHandler.getSavedParseExceptionReports()));
        }
        return events;
    }

    public Map<String, Object> doGetRowStats(boolean isFullReport) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        HashMap<String, RowIngestionMetersTotals> totalsMap = new HashMap<String, RowIngestionMetersTotals>();
        HashMap<String, Map> averagesMap = new HashMap<String, Map>();
        if (IndexTask.addDeterminePartitionStatsToReport(isFullReport, this.ingestionState)) {
            totalsMap.put("determinePartitions", this.determinePartitionsMeters.getTotals());
            averagesMap.put("determinePartitions", this.determinePartitionsMeters.getMovingAverages());
        }
        if (IndexTask.addBuildSegmentStatsToReport(isFullReport, this.ingestionState)) {
            totalsMap.put("buildSegments", this.buildSegmentsMeters.getTotals());
            averagesMap.put("buildSegments", this.buildSegmentsMeters.getMovingAverages());
        }
        returnMap.put("totals", totalsMap);
        returnMap.put("movingAverages", averagesMap);
        return returnMap;
    }

    @GET
    @Path(value="/rowStats")
    @Produces(value={"application/json"})
    public Response getRowStats(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        return Response.ok(this.doGetRowStats(full != null)).build();
    }

    @GET
    @Path(value="/liveReports")
    @Produces(value={"application/json"})
    public Response getLiveReports(@Context HttpServletRequest req, @QueryParam(value="full") String full) {
        IndexTaskUtils.datasourceAuthorizationCheck(req, Action.READ, this.getDataSource(), this.authorizerMapper);
        TaskReport.ReportMap liveReports = this.buildLiveIngestionStatsReport(this.ingestionState, this.getTaskCompletionUnparseableEvents(), this.doGetRowStats(full != null));
        return Response.ok((Object)liveReports).build();
    }

    @JsonProperty(value="spec")
    public IndexIngestionSpec getIngestionSchema() {
        return this.ingestionSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskStatus runTask(TaskToolbox toolbox) {
        try {
            DataSchema dataSchema;
            this.emitMetric(toolbox.getEmitter(), "ingest/count", 1);
            log.debug("Found chat handler of class[%s]", new Object[]{toolbox.getChatHandlerProvider().getClass().getName()});
            if (toolbox.getChatHandlerProvider().get(this.getId()).isPresent()) {
                log.warn("Chat handler is already registered. Skipping chat handler registration.", new Object[0]);
            } else {
                toolbox.getChatHandlerProvider().register(this.getId(), (ChatHandler)this, false);
            }
            this.authorizerMapper = toolbox.getAuthorizerMapper();
            this.determinePartitionsMeters = toolbox.getRowIngestionMetersFactory().createRowIngestionMeters();
            this.buildSegmentsMeters = toolbox.getRowIngestionMetersFactory().createRowIngestionMeters();
            this.determinePartitionsParseExceptionHandler = new ParseExceptionHandler(this.determinePartitionsMeters, this.ingestionSchema.getTuningConfig().isLogParseExceptions(), this.ingestionSchema.getTuningConfig().getMaxParseExceptions(), this.ingestionSchema.getTuningConfig().getMaxSavedParseExceptions());
            this.buildSegmentsParseExceptionHandler = new ParseExceptionHandler(this.buildSegmentsMeters, this.ingestionSchema.getTuningConfig().isLogParseExceptions(), this.ingestionSchema.getTuningConfig().getMaxParseExceptions(), this.ingestionSchema.getTuningConfig().getMaxSavedParseExceptions());
            boolean determineIntervals = this.ingestionSchema.getDataSchema().getGranularitySpec().inputIntervals().isEmpty();
            InputSource inputSource = this.ingestionSchema.getIOConfig().getNonNullInputSource(toolbox);
            File tmpDir = toolbox.getIndexingTmpDir();
            this.ingestionState = IngestionState.DETERMINE_PARTITIONS;
            IndexTuningConfig tuningConfig = this.ingestionSchema.tuningConfig;
            PartitionsSpec partitionsSpec = tuningConfig.getGivenOrDefaultPartitionsSpec();
            PartitionAnalysis partitionAnalysis = this.determineShardSpecs(toolbox, inputSource, tmpDir, partitionsSpec);
            ArrayList<Interval> allocateIntervals = new ArrayList<Interval>(partitionAnalysis.getAllIntervalsToIndex());
            if (determineIntervals) {
                boolean gotLocks = this.determineLockGranularityAndTryLock(toolbox.getTaskActionClient(), allocateIntervals);
                if (!gotLocks) {
                    throw new ISE("Failed to get locks for intervals[%s]", new Object[]{allocateIntervals});
                }
                dataSchema = this.ingestionSchema.getDataSchema().withGranularitySpec(this.ingestionSchema.getDataSchema().getGranularitySpec().withIntervals(JodaUtils.condenseIntervals(allocateIntervals)));
            } else {
                dataSchema = this.ingestionSchema.getDataSchema();
            }
            this.ingestionState = IngestionState.BUILD_SEGMENTS;
            TaskStatus taskStatus = this.generateAndPublishSegments(toolbox, dataSchema, inputSource, tmpDir, partitionAnalysis);
            return taskStatus;
        }
        catch (Exception e) {
            log.error((Throwable)e, "Encountered exception in %s.", new Object[]{this.ingestionState});
            this.errorMsg = Throwables.getStackTraceAsString((Throwable)e);
            this.updateAndWriteCompletionReports(toolbox);
            TaskStatus taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
            return taskStatus;
        }
        finally {
            toolbox.getChatHandlerProvider().unregister(this.getId());
        }
    }

    private void updateAndWriteCompletionReports(TaskToolbox toolbox) {
        this.updateAndWriteCompletionReports(toolbox, null, null);
    }

    private void updateAndWriteCompletionReports(TaskToolbox toolbox, Long segmentsRead, Long segmentsPublished) {
        this.completionReports = this.buildIngestionStatsAndContextReport(this.ingestionState, this.errorMsg, segmentsRead, segmentsPublished);
        if (this.isStandAloneTask) {
            toolbox.getTaskReportFileWriter().write(this.getId(), this.completionReports);
        }
    }

    @Override
    protected Map<String, Object> getTaskCompletionUnparseableEvents() {
        HashMap<String, Object> unparseableEventsMap = new HashMap<String, Object>();
        CircularBuffer determinePartitionsParseExceptionReports = this.determinePartitionsParseExceptionHandler.getSavedParseExceptionReports();
        CircularBuffer buildSegmentsParseExceptionReports = this.buildSegmentsParseExceptionHandler.getSavedParseExceptionReports();
        if (determinePartitionsParseExceptionReports != null || buildSegmentsParseExceptionReports != null) {
            unparseableEventsMap.put("determinePartitions", IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)determinePartitionsParseExceptionReports));
            unparseableEventsMap.put("buildSegments", IndexTaskUtils.getReportListFromSavedParseExceptions((CircularBuffer<ParseExceptionReport>)buildSegmentsParseExceptionReports));
        }
        return unparseableEventsMap;
    }

    @Override
    protected Map<String, Object> getTaskCompletionRowStats() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        metrics.put("determinePartitions", this.determinePartitionsMeters.getTotals());
        metrics.put("buildSegments", this.buildSegmentsMeters.getTotals());
        return metrics;
    }

    private PartitionAnalysis determineShardSpecs(TaskToolbox toolbox, InputSource inputSource, File tmpDir, @Nonnull PartitionsSpec partitionsSpec) throws IOException {
        ObjectMapper jsonMapper = toolbox.getJsonMapper();
        GranularitySpec granularitySpec = this.ingestionSchema.getDataSchema().getGranularitySpec();
        boolean determineIntervals = granularitySpec.inputIntervals().isEmpty();
        boolean determineNumPartitions = partitionsSpec.needsDeterminePartitions(false);
        if (!determineNumPartitions && !determineIntervals) {
            log.info("Skipping determine partition scan", new Object[0]);
            if (partitionsSpec.getType() == SecondaryPartitionType.HASH) {
                return PartialHashSegmentGenerateTask.createHashPartitionAnalysisFromPartitionsSpec(granularitySpec, (HashedPartitionsSpec)partitionsSpec, null);
            }
            if (partitionsSpec.getType() == SecondaryPartitionType.LINEAR) {
                return IndexTask.createLinearPartitionAnalysis(granularitySpec, (DynamicPartitionsSpec)partitionsSpec);
            }
            throw new UOE("%s", new Object[]{partitionsSpec.getClass().getName()});
        }
        log.info("Determining intervals and shardSpecs", new Object[0]);
        return this.createShardSpecsFromInput(jsonMapper, this.ingestionSchema, inputSource, tmpDir, granularitySpec, partitionsSpec, determineIntervals);
    }

    private static boolean addDeterminePartitionStatsToReport(boolean isFullReport, IngestionState ingestionState) {
        return isFullReport || ingestionState == IngestionState.DETERMINE_PARTITIONS;
    }

    private static LinearPartitionAnalysis createLinearPartitionAnalysis(GranularitySpec granularitySpec, @Nonnull DynamicPartitionsSpec partitionsSpec) {
        Iterable intervals = granularitySpec.sortedBucketIntervals();
        boolean numBucketsPerInterval = true;
        LinearPartitionAnalysis partitionAnalysis = new LinearPartitionAnalysis(partitionsSpec);
        intervals.forEach(interval -> partitionAnalysis.updateBucket((Interval)interval, 1));
        return partitionAnalysis;
    }

    private PartitionAnalysis createShardSpecsFromInput(ObjectMapper jsonMapper, IndexIngestionSpec ingestionSchema, InputSource inputSource, File tmpDir, GranularitySpec granularitySpec, @Nonnull PartitionsSpec partitionsSpec, boolean determineIntervals) throws IOException {
        PartitionAnalysis<Integer, DynamicPartitionsSpec> partitionAnalysis;
        assert (partitionsSpec.getType() != SecondaryPartitionType.RANGE);
        long determineShardSpecsStartMillis = System.currentTimeMillis();
        Map<Interval, Optional<HyperLogLogCollector>> hllCollectors = this.collectIntervalsAndShardSpecs(jsonMapper, ingestionSchema, inputSource, tmpDir, granularitySpec, partitionsSpec, determineIntervals);
        if (partitionsSpec.getType() == SecondaryPartitionType.LINEAR) {
            partitionAnalysis = new LinearPartitionAnalysis((DynamicPartitionsSpec)partitionsSpec);
        } else if (partitionsSpec.getType() == SecondaryPartitionType.HASH) {
            partitionAnalysis = new HashPartitionAnalysis((HashedPartitionsSpec)partitionsSpec);
        } else {
            throw new UOE("%s", new Object[]{partitionsSpec.getClass().getName()});
        }
        for (Map.Entry<Interval, Optional<HyperLogLogCollector>> entry : hllCollectors.entrySet()) {
            int numBucketsPerInterval;
            Interval interval = entry.getKey();
            if (partitionsSpec.getType() == SecondaryPartitionType.HASH) {
                HashedPartitionsSpec hashedPartitionsSpec = (HashedPartitionsSpec)partitionsSpec;
                HyperLogLogCollector collector = (HyperLogLogCollector)entry.getValue().orNull();
                if (partitionsSpec.needsDeterminePartitions(false)) {
                    long numRows = ((HyperLogLogCollector)Preconditions.checkNotNull((Object)collector, (Object)"HLL collector")).estimateCardinalityRound();
                    int nonNullMaxRowsPerSegment = partitionsSpec.getMaxRowsPerSegment() == null ? 5000000 : partitionsSpec.getMaxRowsPerSegment();
                    numBucketsPerInterval = (int)Math.ceil((double)numRows / (double)nonNullMaxRowsPerSegment);
                    log.info("Estimated [%,d] rows of data for interval [%s], creating [%,d] shards", new Object[]{numRows, interval, numBucketsPerInterval});
                } else {
                    numBucketsPerInterval = hashedPartitionsSpec.getNumShards() == null ? 1 : hashedPartitionsSpec.getNumShards();
                    log.info("Creating [%,d] buckets for interval [%s]", new Object[]{numBucketsPerInterval, interval});
                }
            } else {
                numBucketsPerInterval = 1;
            }
            partitionAnalysis.updateBucket(interval, numBucketsPerInterval);
        }
        log.info("Found intervals and shardSpecs in %,dms", new Object[]{System.currentTimeMillis() - determineShardSpecsStartMillis});
        return partitionAnalysis;
    }

    private Map<Interval, Optional<HyperLogLogCollector>> collectIntervalsAndShardSpecs(ObjectMapper jsonMapper, IndexIngestionSpec ingestionSchema, InputSource inputSource, File tmpDir, GranularitySpec granularitySpec, @Nonnull PartitionsSpec partitionsSpec, boolean determineIntervals) throws IOException {
        TreeMap<Interval, Optional<HyperLogLogCollector>> hllCollectors = new TreeMap<Interval, Optional<HyperLogLogCollector>>(Comparators.intervalsByStartThenEnd());
        Granularity queryGranularity = granularitySpec.getQueryGranularity();
        try (FilteringCloseableInputRowIterator inputRowIterator = AbstractBatchIndexTask.inputSourceReader(tmpDir, ingestionSchema.getDataSchema(), inputSource, inputSource.needsFormat() ? IndexTask.getInputFormat(ingestionSchema) : null, IndexTask.allowNonNullRowsWithinInputIntervalsOf(granularitySpec), this.determinePartitionsMeters, this.determinePartitionsParseExceptionHandler);){
            while (inputRowIterator.hasNext()) {
                Interval interval;
                InputRow inputRow = (InputRow)inputRowIterator.next();
                if (determineIntervals) {
                    interval = granularitySpec.getSegmentGranularity().bucket(inputRow.getTimestamp());
                } else {
                    Optional optInterval = granularitySpec.bucketInterval(inputRow.getTimestamp());
                    assert (optInterval.isPresent());
                    interval = (Interval)optInterval.get();
                }
                if (partitionsSpec.needsDeterminePartitions(false)) {
                    hllCollectors.computeIfAbsent(interval, intv -> Optional.of((Object)HyperLogLogCollector.makeLatestCollector()));
                    List groupKey = Rows.toGroupKey((long)queryGranularity.bucketStart(inputRow.getTimestampFromEpoch()), (InputRow)inputRow);
                    ((HyperLogLogCollector)((Optional)hllCollectors.get(interval)).get()).add(HASH_FUNCTION.hashBytes(jsonMapper.writeValueAsBytes((Object)groupKey)).asBytes());
                } else {
                    hllCollectors.putIfAbsent(interval, (Optional<HyperLogLogCollector>)Optional.absent());
                }
                this.determinePartitionsMeters.incrementProcessed();
            }
        }
        if (this.determinePartitionsMeters.getThrownAway() > 0L) {
            log.warn("Unable to find a matching interval for [%,d] events", new Object[]{this.determinePartitionsMeters.getThrownAway()});
        }
        if (this.determinePartitionsMeters.getUnparseable() > 0L) {
            log.warn("Unable to parse [%,d] events", new Object[]{this.determinePartitionsMeters.getUnparseable()});
        }
        return hllCollectors;
    }

    public IngestionState getIngestionState() {
        return this.ingestionState;
    }

    private TaskStatus generateAndPublishSegments(TaskToolbox toolbox, DataSchema dataSchema, InputSource inputSource, File tmpDir, PartitionAnalysis partitionAnalysis) throws IOException, InterruptedException {
        SegmentAllocatorForBatch segmentAllocator;
        SequenceNameFunction sequenceNameFunction;
        SegmentGenerationMetrics buildSegmentsSegmentGenerationMetrics = new SegmentGenerationMetrics();
        TaskRealtimeMetricsMonitor metricsMonitor = TaskRealtimeMetricsMonitorBuilder.build(this, buildSegmentsSegmentGenerationMetrics, this.buildSegmentsMeters);
        toolbox.addMonitor((Monitor)metricsMonitor);
        Object partitionsSpec = partitionAnalysis.getPartitionsSpec();
        IndexTuningConfig tuningConfig = this.ingestionSchema.getTuningConfig();
        long pushTimeout = tuningConfig.getPushTimeout();
        switch (partitionsSpec.getType()) {
            case HASH: 
            case RANGE: {
                SegmentAllocatorForBatch localSegmentAllocator = SegmentAllocators.forNonLinearPartitioning(toolbox, this.getDataSource(), this.baseSequenceName, dataSchema.getGranularitySpec(), null, (CompletePartitionAnalysis)partitionAnalysis);
                sequenceNameFunction = localSegmentAllocator.getSequenceNameFunction();
                segmentAllocator = localSegmentAllocator;
                break;
            }
            case LINEAR: {
                segmentAllocator = SegmentAllocators.forLinearPartitioning(toolbox, this.baseSequenceName, null, dataSchema, this.getTaskLockHelper(), this.getIngestionMode(), partitionAnalysis.getPartitionsSpec(), null);
                sequenceNameFunction = segmentAllocator.getSequenceNameFunction();
                break;
            }
            default: {
                throw new UOE("[%s] secondary partition type is not supported", new Object[]{partitionsSpec.getType()});
            }
        }
        TaskLockType taskLockType = this.getTaskLockHelper().getLockTypeToUse();
        TransactionalSegmentPublisher publisher = (segmentsToBeOverwritten, segmentsToPublish, commitMetadata, map) -> toolbox.getTaskActionClient().submit(this.buildPublishAction(segmentsToBeOverwritten, segmentsToPublish, map, taskLockType));
        String effectiveId = this.getContextValue("appenderatorTrackingTaskId", null);
        if (effectiveId == null) {
            effectiveId = this.getId();
        }
        Appenderator appenderator = BatchAppenderators.newAppenderator(effectiveId, toolbox.getAppenderatorsManager(), buildSegmentsSegmentGenerationMetrics, toolbox, dataSchema, tuningConfig, this.buildSegmentsMeters, this.buildSegmentsParseExceptionHandler, this.isUseMaxMemoryEstimates());
        boolean exceptionOccurred = false;
        try {
            TaskStatus taskStatus;
            block26: {
                SegmentsAndCommitMetadata published;
                Set<Object> tombStones;
                BatchAppenderatorDriver driver;
                block24: {
                    block25: {
                        driver = BatchAppenderators.newDriver(appenderator, toolbox, segmentAllocator);
                        try {
                            driver.startJob();
                            Pair<SegmentsAndCommitMetadata, SegmentSchemaMapping> commitMetadataAndSchema = InputSourceProcessor.process(dataSchema, driver, partitionsSpec, inputSource, inputSource.needsFormat() ? IndexTask.getInputFormat(this.ingestionSchema) : null, tmpDir, sequenceNameFunction, new DefaultIndexTaskInputRowIteratorBuilder(), this.buildSegmentsMeters, this.buildSegmentsParseExceptionHandler, pushTimeout);
                            SegmentsAndCommitMetadata pushed = (SegmentsAndCommitMetadata)commitMetadataAndSchema.lhs;
                            Set<DataSegment> inputSegments = this.getTaskLockHelper().isUseSegmentLock() ? this.getTaskLockHelper().getLockedExistingSegments() : null;
                            boolean storeCompactionState = this.getContextValue("storeCompactionState", false);
                            Function<Set<DataSegment>, Set<DataSegment>> annotateFunction = IndexTask.addCompactionStateToSegments(storeCompactionState, toolbox, this.ingestionSchema);
                            tombStones = Collections.emptySet();
                            if (this.getIngestionMode() == AbstractTask.IngestionMode.REPLACE) {
                                TombstoneHelper tombstoneHelper = new TombstoneHelper(toolbox.getTaskActionClient());
                                List<Interval> tombstoneIntervals = tombstoneHelper.computeTombstoneIntervals(pushed.getSegments(), this.ingestionSchema.getDataSchema());
                                HashMap<Interval, SegmentIdWithShardSpec> tombstonesAndVersions = new HashMap<Interval, SegmentIdWithShardSpec>();
                                for (Interval interval : tombstoneIntervals) {
                                    SegmentIdWithShardSpec segmentIdWithShardSpec = this.allocateNewSegmentForTombstone(this.ingestionSchema, interval.getStart());
                                    tombstonesAndVersions.put(interval, segmentIdWithShardSpec);
                                }
                                tombStones = tombstoneHelper.computeTombstones(this.ingestionSchema.getDataSchema(), tombstonesAndVersions);
                                log.debugSegments(tombStones, "To publish tombstones");
                            }
                            published = IndexTask.awaitPublish((ListenableFuture<SegmentsAndCommitMetadata>)driver.publishAll(inputSegments, tombStones, publisher, annotateFunction, (SegmentSchemaMapping)commitMetadataAndSchema.rhs), pushTimeout);
                            appenderator.close();
                            if (tuningConfig.getAwaitSegmentAvailabilityTimeoutMillis() > 0L && published != null) {
                                this.ingestionState = IngestionState.SEGMENT_AVAILABILITY_WAIT;
                                ArrayList<DataSegment> segmentsToWaitFor = new ArrayList<DataSegment>(published.getSegments());
                                this.waitForSegmentAvailability(toolbox, segmentsToWaitFor, tuningConfig.getAwaitSegmentAvailabilityTimeoutMillis());
                            }
                            this.ingestionState = IngestionState.COMPLETED;
                            if (published != null) break block24;
                            log.error("Failed to publish segments, aborting!", new Object[0]);
                            this.errorMsg = "Failed to publish segments.";
                            this.updateAndWriteCompletionReports(toolbox);
                            taskStatus = TaskStatus.failure((String)this.getId(), (String)this.errorMsg);
                            if (driver == null) break block25;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (driver != null) {
                                    try {
                                        driver.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (ExecutionException | TimeoutException e) {
                                exceptionOccurred = true;
                                throw new RuntimeException(e);
                            }
                            catch (Exception e) {
                                exceptionOccurred = true;
                                throw e;
                            }
                        }
                        driver.close();
                    }
                    return taskStatus;
                }
                log.info("Processed[%,d] events, unparseable[%,d], thrownAway[%,d].", new Object[]{this.buildSegmentsMeters.getProcessed(), this.buildSegmentsMeters.getUnparseable(), this.buildSegmentsMeters.getThrownAway()});
                log.info("Published [%s] segments", new Object[]{published.getSegments().size()});
                this.emitMetric(toolbox.getEmitter(), "ingest/tombstones/count", tombStones.size());
                this.emitMetric(toolbox.getEmitter(), "ingest/segments/count", published.getSegments().size() + tombStones.size());
                log.debugSegments((Collection)published.getSegments(), "Published segments");
                this.updateAndWriteCompletionReports(toolbox, inputSource instanceof DruidInputSource ? Long.valueOf(((DruidInputSource)inputSource).getNumberOfSegmentsRead()) : null, Long.valueOf(published.getSegments().size()));
                taskStatus = TaskStatus.success((String)this.getId());
                if (driver == null) break block26;
                driver.close();
            }
            return taskStatus;
        }
        finally {
            if (exceptionOccurred) {
                appenderator.closeNow();
            } else {
                appenderator.close();
            }
            toolbox.removeMonitor((Monitor)metricsMonitor);
        }
    }

    private static SegmentsAndCommitMetadata awaitPublish(ListenableFuture<SegmentsAndCommitMetadata> publishFuture, long publishTimeout) throws ExecutionException, InterruptedException, TimeoutException {
        if (publishTimeout == 0L) {
            return (SegmentsAndCommitMetadata)publishFuture.get();
        }
        return (SegmentsAndCommitMetadata)publishFuture.get(publishTimeout, TimeUnit.MILLISECONDS);
    }

    private static InputFormat getInputFormat(IndexIngestionSpec ingestionSchema) {
        return ingestionSchema.getIOConfig().getNonNullInputFormat();
    }

    @Override
    public void cleanUp(TaskToolbox toolbox, @Nullable TaskStatus taskStatus) throws Exception {
        if (this.isStandAloneTask) {
            super.cleanUp(toolbox, taskStatus);
        }
    }

    public static class IndexTuningConfig
    implements AppenderatorConfig {
        private static final IndexSpec DEFAULT_INDEX_SPEC = IndexSpec.DEFAULT;
        private static final int DEFAULT_MAX_PENDING_PERSISTS = 0;
        private static final boolean DEFAULT_GUARANTEE_ROLLUP = false;
        private static final boolean DEFAULT_REPORT_PARSE_EXCEPTIONS = false;
        private static final long DEFAULT_PUSH_TIMEOUT = 0L;
        private final AppendableIndexSpec appendableIndexSpec;
        private final int maxRowsInMemory;
        private final long maxBytesInMemory;
        private final boolean skipBytesInMemoryOverheadCheck;
        private final int maxColumnsToMerge;
        @Nullable
        private final PartitionsSpec partitionsSpec;
        private final IndexSpec indexSpec;
        private final IndexSpec indexSpecForIntermediatePersists;
        private final File basePersistDirectory;
        private final int maxPendingPersists;
        private final boolean forceGuaranteedRollup;
        private final boolean reportParseExceptions;
        private final long pushTimeout;
        private final boolean logParseExceptions;
        private final int maxParseExceptions;
        private final int maxSavedParseExceptions;
        private final long awaitSegmentAvailabilityTimeoutMillis;
        @Nullable
        private final SegmentWriteOutMediumFactory segmentWriteOutMediumFactory;
        private final int numPersistThreads;

        @Nullable
        private static PartitionsSpec getPartitionsSpec(boolean forceGuaranteedRollup, @Nullable PartitionsSpec partitionsSpec, @Nullable Integer maxRowsPerSegment, @Nullable Long maxTotalRows, @Nullable Integer numShards, @Nullable List<String> partitionDimensions) {
            if (partitionsSpec == null) {
                if (forceGuaranteedRollup) {
                    if (maxRowsPerSegment != null || numShards != null || partitionDimensions != null && !partitionDimensions.isEmpty()) {
                        return new HashedPartitionsSpec(maxRowsPerSegment, numShards, partitionDimensions);
                    }
                    return null;
                }
                if (maxRowsPerSegment != null || maxTotalRows != null) {
                    return new DynamicPartitionsSpec(maxRowsPerSegment, maxTotalRows);
                }
                return null;
            }
            if (forceGuaranteedRollup) {
                if (!partitionsSpec.isForceGuaranteedRollupCompatibleType()) {
                    throw new IAE(partitionsSpec.getClass().getSimpleName() + " cannot be used for perfect rollup", new Object[0]);
                }
            } else if (!(partitionsSpec instanceof DynamicPartitionsSpec)) {
                throw new IAE("DynamicPartitionsSpec must be used for best-effort rollup", new Object[0]);
            }
            return partitionsSpec;
        }

        @JsonCreator
        public IndexTuningConfig(@JsonProperty(value="targetPartitionSize") @Deprecated @Nullable Integer targetPartitionSize, @JsonProperty(value="maxRowsPerSegment") @Deprecated @Nullable Integer maxRowsPerSegment, @JsonProperty(value="appendableIndexSpec") @Nullable AppendableIndexSpec appendableIndexSpec, @JsonProperty(value="maxRowsInMemory") @Nullable Integer maxRowsInMemory, @JsonProperty(value="maxBytesInMemory") @Nullable Long maxBytesInMemory, @JsonProperty(value="skipBytesInMemoryOverheadCheck") @Nullable Boolean skipBytesInMemoryOverheadCheck, @JsonProperty(value="maxTotalRows") @Deprecated @Nullable Long maxTotalRows, @JsonProperty(value="rowFlushBoundary") @Deprecated @Nullable Integer rowFlushBoundary_forBackCompatibility, @JsonProperty(value="numShards") @Deprecated @Nullable Integer numShards, @JsonProperty(value="partitionDimensions") @Deprecated @Nullable List<String> partitionDimensions, @JsonProperty(value="partitionsSpec") @Nullable PartitionsSpec partitionsSpec, @JsonProperty(value="indexSpec") @Nullable IndexSpec indexSpec, @JsonProperty(value="indexSpecForIntermediatePersists") @Nullable IndexSpec indexSpecForIntermediatePersists, @JsonProperty(value="maxPendingPersists") @Nullable Integer maxPendingPersists, @JsonProperty(value="forceGuaranteedRollup") @Nullable Boolean forceGuaranteedRollup, @JsonProperty(value="reportParseExceptions") @Deprecated @Nullable Boolean reportParseExceptions, @JsonProperty(value="publishTimeout") @Deprecated @Nullable Long publishTimeout, @JsonProperty(value="pushTimeout") @Nullable Long pushTimeout, @JsonProperty(value="segmentWriteOutMediumFactory") @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @JsonProperty(value="logParseExceptions") @Nullable Boolean logParseExceptions, @JsonProperty(value="maxParseExceptions") @Nullable Integer maxParseExceptions, @JsonProperty(value="maxSavedParseExceptions") @Nullable Integer maxSavedParseExceptions, @JsonProperty(value="maxColumnsToMerge") @Nullable Integer maxColumnsToMerge, @JsonProperty(value="awaitSegmentAvailabilityTimeoutMillis") @Nullable Long awaitSegmentAvailabilityTimeoutMillis, @JsonProperty(value="numPersistThreads") @Nullable Integer numPersistThreads) {
            this(appendableIndexSpec, maxRowsInMemory != null ? maxRowsInMemory : rowFlushBoundary_forBackCompatibility, maxBytesInMemory != null ? maxBytesInMemory : 0L, skipBytesInMemoryOverheadCheck != null ? skipBytesInMemoryOverheadCheck : false, IndexTuningConfig.getPartitionsSpec(forceGuaranteedRollup == null ? false : forceGuaranteedRollup, partitionsSpec, maxRowsPerSegment == null ? targetPartitionSize : maxRowsPerSegment, maxTotalRows, numShards, partitionDimensions), indexSpec, indexSpecForIntermediatePersists, maxPendingPersists, forceGuaranteedRollup, reportParseExceptions, pushTimeout != null ? pushTimeout : publishTimeout, null, segmentWriteOutMediumFactory, logParseExceptions, maxParseExceptions, maxSavedParseExceptions, maxColumnsToMerge, awaitSegmentAvailabilityTimeoutMillis, numPersistThreads);
            Preconditions.checkArgument((targetPartitionSize == null || maxRowsPerSegment == null ? 1 : 0) != 0, (Object)"Can't use targetPartitionSize and maxRowsPerSegment together");
        }

        private IndexTuningConfig() {
            this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }

        private IndexTuningConfig(@Nullable AppendableIndexSpec appendableIndexSpec, @Nullable Integer maxRowsInMemory, @Nullable Long maxBytesInMemory, @Nullable Boolean skipBytesInMemoryOverheadCheck, @Nullable PartitionsSpec partitionsSpec, @Nullable IndexSpec indexSpec, @Nullable IndexSpec indexSpecForIntermediatePersists, @Nullable Integer maxPendingPersists, @Nullable Boolean forceGuaranteedRollup, @Nullable Boolean reportParseExceptions, @Nullable Long pushTimeout, @Nullable File basePersistDirectory, @Nullable SegmentWriteOutMediumFactory segmentWriteOutMediumFactory, @Nullable Boolean logParseExceptions, @Nullable Integer maxParseExceptions, @Nullable Integer maxSavedParseExceptions, @Nullable Integer maxColumnsToMerge, @Nullable Long awaitSegmentAvailabilityTimeoutMillis, @Nullable Integer numPersistThreads) {
            this.appendableIndexSpec = appendableIndexSpec == null ? DEFAULT_APPENDABLE_INDEX : appendableIndexSpec;
            this.maxRowsInMemory = maxRowsInMemory == null ? 1000000 : maxRowsInMemory;
            this.maxBytesInMemory = maxBytesInMemory == null ? 0L : maxBytesInMemory;
            this.skipBytesInMemoryOverheadCheck = skipBytesInMemoryOverheadCheck == null ? false : skipBytesInMemoryOverheadCheck;
            this.maxColumnsToMerge = maxColumnsToMerge == null ? -1 : maxColumnsToMerge;
            this.partitionsSpec = partitionsSpec;
            this.indexSpec = indexSpec == null ? DEFAULT_INDEX_SPEC : indexSpec;
            this.indexSpecForIntermediatePersists = indexSpecForIntermediatePersists == null ? this.indexSpec : indexSpecForIntermediatePersists;
            this.maxPendingPersists = maxPendingPersists == null ? 0 : maxPendingPersists;
            this.forceGuaranteedRollup = forceGuaranteedRollup == null ? false : forceGuaranteedRollup;
            this.reportParseExceptions = reportParseExceptions == null ? false : reportParseExceptions;
            this.pushTimeout = pushTimeout == null ? 0L : pushTimeout;
            this.basePersistDirectory = basePersistDirectory;
            this.segmentWriteOutMediumFactory = segmentWriteOutMediumFactory;
            if (this.reportParseExceptions) {
                this.maxParseExceptions = 0;
                this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : Math.min(1, maxSavedParseExceptions);
            } else {
                this.maxParseExceptions = maxParseExceptions == null ? Integer.MAX_VALUE : maxParseExceptions;
                this.maxSavedParseExceptions = maxSavedParseExceptions == null ? 0 : maxSavedParseExceptions;
            }
            this.logParseExceptions = logParseExceptions == null ? false : logParseExceptions;
            this.awaitSegmentAvailabilityTimeoutMillis = awaitSegmentAvailabilityTimeoutMillis == null || awaitSegmentAvailabilityTimeoutMillis < 0L ? 0L : awaitSegmentAvailabilityTimeoutMillis;
            this.numPersistThreads = numPersistThreads == null ? 1 : Math.max(numPersistThreads, 1);
        }

        public IndexTuningConfig withBasePersistDirectory(File dir) {
            return new IndexTuningConfig(this.appendableIndexSpec, this.maxRowsInMemory, this.maxBytesInMemory, this.skipBytesInMemoryOverheadCheck, this.partitionsSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.maxPendingPersists, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, dir, this.segmentWriteOutMediumFactory, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions, this.maxColumnsToMerge, this.awaitSegmentAvailabilityTimeoutMillis, this.numPersistThreads);
        }

        @JsonProperty
        public AppendableIndexSpec getAppendableIndexSpec() {
            return this.appendableIndexSpec;
        }

        @JsonProperty
        public int getMaxRowsInMemory() {
            return this.maxRowsInMemory;
        }

        @JsonProperty
        public long getMaxBytesInMemory() {
            return this.maxBytesInMemory;
        }

        @JsonProperty
        public boolean isSkipBytesInMemoryOverheadCheck() {
            return this.skipBytesInMemoryOverheadCheck;
        }

        @JsonProperty
        @Nullable
        public PartitionsSpec getPartitionsSpec() {
            return this.partitionsSpec;
        }

        public PartitionsSpec getGivenOrDefaultPartitionsSpec() {
            if (this.partitionsSpec != null) {
                return this.partitionsSpec;
            }
            return this.forceGuaranteedRollup ? new HashedPartitionsSpec(null, null, null) : new DynamicPartitionsSpec(null, null);
        }

        @JsonProperty
        public IndexSpec getIndexSpec() {
            return this.indexSpec;
        }

        @JsonProperty
        public IndexSpec getIndexSpecForIntermediatePersists() {
            return this.indexSpecForIntermediatePersists;
        }

        @JsonProperty
        public int getMaxPendingPersists() {
            return this.maxPendingPersists;
        }

        @JsonProperty
        public boolean isForceGuaranteedRollup() {
            return this.forceGuaranteedRollup;
        }

        @JsonProperty
        public boolean isReportParseExceptions() {
            return this.reportParseExceptions;
        }

        @JsonProperty
        public long getPushTimeout() {
            return this.pushTimeout;
        }

        @Nullable
        @JsonProperty
        public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
            return this.segmentWriteOutMediumFactory;
        }

        @JsonProperty
        public int getMaxColumnsToMerge() {
            return this.maxColumnsToMerge;
        }

        @JsonProperty
        public boolean isLogParseExceptions() {
            return this.logParseExceptions;
        }

        @JsonProperty
        public int getMaxParseExceptions() {
            return this.maxParseExceptions;
        }

        @JsonProperty
        public int getMaxSavedParseExceptions() {
            return this.maxSavedParseExceptions;
        }

        @Nullable
        @Deprecated
        @JsonProperty
        public Integer getMaxRowsPerSegment() {
            return this.partitionsSpec == null ? null : this.partitionsSpec.getMaxRowsPerSegment();
        }

        @Nullable
        @Deprecated
        @JsonProperty
        public Long getMaxTotalRows() {
            return this.partitionsSpec instanceof DynamicPartitionsSpec ? ((DynamicPartitionsSpec)this.partitionsSpec).getMaxTotalRows() : null;
        }

        @Deprecated
        @Nullable
        @JsonProperty
        public Integer getNumShards() {
            return this.partitionsSpec instanceof HashedPartitionsSpec ? ((HashedPartitionsSpec)this.partitionsSpec).getNumShards() : null;
        }

        @Deprecated
        @JsonProperty
        public List<String> getPartitionDimensions() {
            return this.partitionsSpec instanceof HashedPartitionsSpec ? ((HashedPartitionsSpec)this.partitionsSpec).getPartitionDimensions() : Collections.emptyList();
        }

        public File getBasePersistDirectory() {
            return this.basePersistDirectory;
        }

        public Period getIntermediatePersistPeriod() {
            return new Period(Integer.MAX_VALUE);
        }

        @JsonProperty
        public long getAwaitSegmentAvailabilityTimeoutMillis() {
            return this.awaitSegmentAvailabilityTimeoutMillis;
        }

        @JsonProperty
        public int getNumPersistThreads() {
            return this.numPersistThreads;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexTuningConfig that = (IndexTuningConfig)o;
            return Objects.equals(this.appendableIndexSpec, that.appendableIndexSpec) && this.maxRowsInMemory == that.maxRowsInMemory && this.maxBytesInMemory == that.maxBytesInMemory && this.skipBytesInMemoryOverheadCheck == that.skipBytesInMemoryOverheadCheck && this.maxColumnsToMerge == that.maxColumnsToMerge && this.maxPendingPersists == that.maxPendingPersists && this.forceGuaranteedRollup == that.forceGuaranteedRollup && this.reportParseExceptions == that.reportParseExceptions && this.pushTimeout == that.pushTimeout && this.logParseExceptions == that.logParseExceptions && this.maxParseExceptions == that.maxParseExceptions && this.maxSavedParseExceptions == that.maxSavedParseExceptions && this.numPersistThreads == that.numPersistThreads && Objects.equals(this.partitionsSpec, that.partitionsSpec) && Objects.equals(this.indexSpec, that.indexSpec) && Objects.equals(this.indexSpecForIntermediatePersists, that.indexSpecForIntermediatePersists) && Objects.equals(this.basePersistDirectory, that.basePersistDirectory) && Objects.equals(this.segmentWriteOutMediumFactory, that.segmentWriteOutMediumFactory) && Objects.equals(this.awaitSegmentAvailabilityTimeoutMillis, that.awaitSegmentAvailabilityTimeoutMillis);
        }

        public int hashCode() {
            return Objects.hash(this.appendableIndexSpec, this.maxRowsInMemory, this.maxBytesInMemory, this.skipBytesInMemoryOverheadCheck, this.maxColumnsToMerge, this.partitionsSpec, this.indexSpec, this.indexSpecForIntermediatePersists, this.basePersistDirectory, this.maxPendingPersists, this.forceGuaranteedRollup, this.reportParseExceptions, this.pushTimeout, this.logParseExceptions, this.maxParseExceptions, this.maxSavedParseExceptions, this.segmentWriteOutMediumFactory, this.awaitSegmentAvailabilityTimeoutMillis, this.numPersistThreads);
        }

        public String toString() {
            return "IndexTuningConfig{maxRowsInMemory=" + this.maxRowsInMemory + ", maxBytesInMemory=" + this.maxBytesInMemory + ", skipBytesInMemoryOverheadCheck=" + this.skipBytesInMemoryOverheadCheck + ", maxColumnsToMerge=" + this.maxColumnsToMerge + ", partitionsSpec=" + this.partitionsSpec + ", indexSpec=" + this.indexSpec + ", indexSpecForIntermediatePersists=" + this.indexSpecForIntermediatePersists + ", basePersistDirectory=" + this.basePersistDirectory + ", maxPendingPersists=" + this.maxPendingPersists + ", forceGuaranteedRollup=" + this.forceGuaranteedRollup + ", reportParseExceptions=" + this.reportParseExceptions + ", pushTimeout=" + this.pushTimeout + ", logParseExceptions=" + this.logParseExceptions + ", maxParseExceptions=" + this.maxParseExceptions + ", maxSavedParseExceptions=" + this.maxSavedParseExceptions + ", segmentWriteOutMediumFactory=" + this.segmentWriteOutMediumFactory + ", awaitSegmentAvailabilityTimeoutMillis=" + this.awaitSegmentAvailabilityTimeoutMillis + ", numPersistThreads=" + this.numPersistThreads + '}';
        }
    }

    @JsonTypeName(value="index")
    public static class IndexIOConfig
    implements BatchIOConfig {
        private final InputSource inputSource;
        private final AtomicReference<InputSource> inputSourceWithToolbox = new AtomicReference();
        private final InputFormat inputFormat;
        private boolean appendToExisting;
        private boolean dropExisting;

        @JsonCreator
        public IndexIOConfig(@JsonProperty(value="inputSource") @Nullable InputSource inputSource, @JsonProperty(value="inputFormat") @Nullable InputFormat inputFormat, @JsonProperty(value="appendToExisting") @Nullable Boolean appendToExisting, @JsonProperty(value="dropExisting") @Nullable Boolean dropExisting) {
            this.inputSource = inputSource;
            this.inputFormat = inputFormat;
            this.appendToExisting = appendToExisting == null ? false : appendToExisting;
            this.dropExisting = dropExisting == null ? false : dropExisting;
        }

        @Nullable
        @JsonProperty
        public InputSource getInputSource() {
            return this.inputSource;
        }

        public InputSource getNonNullInputSource() {
            return (InputSource)Preconditions.checkNotNull((Object)this.inputSource, (Object)"inputSource");
        }

        public InputSource getNonNullInputSource(TaskToolbox toolbox) {
            Preconditions.checkNotNull((Object)this.inputSource, (Object)"inputSource");
            if (this.inputSourceWithToolbox.get() == null) {
                if (this.inputSource instanceof TaskInputSource) {
                    this.inputSourceWithToolbox.set(((TaskInputSource)this.inputSource).withTaskToolbox(toolbox));
                } else {
                    this.inputSourceWithToolbox.set(this.inputSource);
                }
            }
            return this.inputSourceWithToolbox.get();
        }

        @Nullable
        @JsonProperty
        public InputFormat getInputFormat() {
            return this.inputFormat;
        }

        public InputFormat getNonNullInputFormat() {
            return (InputFormat)Preconditions.checkNotNull((Object)this.inputFormat, (Object)"inputFormat");
        }

        public boolean isAppendToExisting() {
            return this.appendToExisting;
        }

        public boolean isDropExisting() {
            return this.dropExisting;
        }
    }

    public static class IndexIngestionSpec
    extends IngestionSpec<IndexIOConfig, IndexTuningConfig> {
        private final DataSchema dataSchema;
        private final IndexIOConfig ioConfig;
        private final IndexTuningConfig tuningConfig;

        @JsonCreator
        public IndexIngestionSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") IndexIOConfig ioConfig, @JsonProperty(value="tuningConfig") IndexTuningConfig tuningConfig) {
            super(dataSchema, (IOConfig)ioConfig, (TuningConfig)tuningConfig);
            if (dataSchema.getParserMap() != null && ioConfig.getInputSource() != null) {
                throw new IAE("Cannot use parser and inputSource together. Try using inputFormat instead of parser.", new Object[0]);
            }
            AbstractTask.IngestionMode ingestionMode = AbstractTask.computeBatchIngestionMode(ioConfig);
            if (ingestionMode == AbstractTask.IngestionMode.REPLACE && dataSchema.getGranularitySpec().inputIntervals().isEmpty()) {
                throw new IAE("GranularitySpec's intervals cannot be empty for replace.", new Object[0]);
            }
            if (ioConfig.getInputSource() != null && ioConfig.getInputSource().needsFormat()) {
                Checks.checkOneNotNullOrEmpty((List)ImmutableList.of((Object)new Property("parser", (Object)dataSchema.getParserMap()), (Object)new Property("inputFormat", (Object)ioConfig.getInputFormat())));
            }
            this.dataSchema = dataSchema;
            this.ioConfig = ioConfig;
            this.tuningConfig = tuningConfig == null ? new IndexTuningConfig() : tuningConfig;
        }

        @JsonProperty(value="dataSchema")
        public DataSchema getDataSchema() {
            return this.dataSchema;
        }

        @JsonProperty(value="ioConfig")
        public IndexIOConfig getIOConfig() {
            return this.ioConfig;
        }

        @JsonProperty(value="tuningConfig")
        public IndexTuningConfig getTuningConfig() {
            return this.tuningConfig;
        }
    }
}

