/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.partition;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexing.common.TaskToolbox;
import org.apache.druid.indexing.common.task.batch.partition.CompletePartitionAnalysis;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.timeline.partition.BucketNumberedShardSpec;
import org.apache.druid.timeline.partition.HashBucketShardSpec;
import org.joda.time.Interval;

public class HashPartitionAnalysis
implements CompletePartitionAnalysis<Integer, HashedPartitionsSpec> {
    private final Map<Interval, Integer> intervalToNumBuckets = new HashMap<Interval, Integer>();
    private final HashedPartitionsSpec partitionsSpec;

    public HashPartitionAnalysis(HashedPartitionsSpec partitionsSpec) {
        this.partitionsSpec = partitionsSpec;
    }

    @Override
    public HashedPartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @Override
    public void updateBucket(Interval interval, Integer bucketAnalysis) {
        this.intervalToNumBuckets.put(interval, bucketAnalysis);
    }

    @Override
    public Integer getBucketAnalysis(Interval interval) {
        Integer bucketAnalysis = this.intervalToNumBuckets.get(interval);
        if (bucketAnalysis == null) {
            throw new IAE("Missing bucket analysis for interval[%s]", new Object[]{interval});
        }
        return bucketAnalysis;
    }

    @Override
    public Set<Interval> getAllIntervalsToIndex() {
        return Collections.unmodifiableSet(this.intervalToNumBuckets.keySet());
    }

    @Override
    public int getNumTimePartitions() {
        return this.intervalToNumBuckets.size();
    }

    public void forEach(BiConsumer<Interval, Integer> consumer) {
        this.intervalToNumBuckets.forEach(consumer);
    }

    @Override
    public Map<Interval, List<BucketNumberedShardSpec<?>>> createBuckets(TaskToolbox toolbox) {
        HashMap intervalToLookup = Maps.newHashMapWithExpectedSize((int)this.intervalToNumBuckets.size());
        this.forEach((interval, numBuckets) -> {
            List buckets = IntStream.range(0, numBuckets).mapToObj(i -> new HashBucketShardSpec(i, numBuckets.intValue(), this.partitionsSpec.getPartitionDimensions(), this.partitionsSpec.getPartitionFunction(), toolbox.getJsonMapper())).collect(Collectors.toList());
            intervalToLookup.put(interval, buckets);
        });
        return intervalToLookup;
    }
}

