/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.compact;

import org.apache.druid.indexing.compact.CompactionScheduler;
import org.apache.druid.indexing.compact.CompactionSupervisorSpec;
import org.apache.druid.indexing.overlord.DataSourceMetadata;
import org.apache.druid.indexing.overlord.supervisor.Supervisor;
import org.apache.druid.indexing.overlord.supervisor.SupervisorReport;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.LagStats;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;

public class CompactionSupervisor
implements Supervisor {
    private static final Logger log = new Logger(CompactionSupervisor.class);
    private final String dataSource;
    private final CompactionScheduler scheduler;
    private final CompactionSupervisorSpec supervisorSpec;

    public CompactionSupervisor(CompactionSupervisorSpec supervisorSpec, CompactionScheduler scheduler) {
        this.supervisorSpec = supervisorSpec;
        this.scheduler = scheduler;
        this.dataSource = supervisorSpec.getSpec().getDataSource();
    }

    public void start() {
        if (this.supervisorSpec.isSuspended()) {
            log.info("Suspending compaction for dataSource[%s].", new Object[]{this.dataSource});
            this.scheduler.stopCompaction(this.dataSource);
        } else if (!this.supervisorSpec.getValidationResult().isValid()) {
            log.warn("Cannot start compaction supervisor for datasource[%s] since the compaction supervisor spec is invalid. Reason[%s].", new Object[]{this.dataSource, this.supervisorSpec.getValidationResult().getReason()});
        } else {
            log.info("Starting compaction for dataSource[%s].", new Object[]{this.dataSource});
            this.scheduler.startCompaction(this.dataSource, this.supervisorSpec.getSpec());
        }
    }

    public void stop(boolean stopGracefully) {
        log.info("Stopping compaction for dataSource[%s].", new Object[]{this.dataSource});
        this.scheduler.stopCompaction(this.dataSource);
    }

    public SupervisorReport<AutoCompactionSnapshot> getStatus() {
        AutoCompactionSnapshot snapshot = this.supervisorSpec.isSuspended() ? AutoCompactionSnapshot.builder((String)this.dataSource).withStatus(AutoCompactionSnapshot.AutoCompactionScheduleStatus.NOT_ENABLED).build() : (!this.supervisorSpec.getValidationResult().isValid() ? AutoCompactionSnapshot.builder((String)this.dataSource).withMessage(StringUtils.format((String)"Compaction supervisor spec is invalid. Reason[%s].", (Object[])new Object[]{this.supervisorSpec.getValidationResult().getReason()})).build() : this.scheduler.getCompactionSnapshot(this.dataSource));
        return new SupervisorReport(this.supervisorSpec.getId(), DateTimes.nowUtc(), (Object)snapshot);
    }

    public SupervisorStateManager.State getState() {
        if (!this.scheduler.isRunning()) {
            return State.SCHEDULER_STOPPED;
        }
        if (this.supervisorSpec.isSuspended()) {
            return State.SUSPENDED;
        }
        if (!this.supervisorSpec.getValidationResult().isValid()) {
            return State.INVALID_SPEC;
        }
        return State.RUNNING;
    }

    public void reset(DataSourceMetadata dataSourceMetadata) {
        throw new UnsupportedOperationException("Resetting not supported for 'autocompact' supervisors.");
    }

    public void resetOffsets(DataSourceMetadata resetDataSourceMetadata) {
        throw new UnsupportedOperationException("Resetting offsets not supported for 'autocompact' supervisors.");
    }

    public void checkpoint(int taskGroupId, DataSourceMetadata checkpointMetadata) {
        throw new UnsupportedOperationException("Checkpointing not supported for 'autocompact' supervisors.");
    }

    public LagStats computeLagStats() {
        throw new UnsupportedOperationException("Lag stats not supported for 'autocompact' supervisors.");
    }

    public int getActiveTaskGroupsCount() {
        throw new UnsupportedOperationException("Task groups not supported for 'autocompact' supervisors.");
    }

    public static enum State implements SupervisorStateManager.State
    {
        SCHEDULER_STOPPED(true),
        RUNNING(true),
        SUSPENDED(true),
        INVALID_SPEC(false),
        UNHEALTHY(false);

        private final boolean healthy;

        private State(boolean healthy) {
            this.healthy = healthy;
        }

        public boolean isFirstRunOnly() {
            return false;
        }

        public boolean isHealthy() {
            return this.healthy;
        }
    }
}

