/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.input;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.druid.data.input.BytesCountingInputEntity;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputEntityReader;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.indexing.input.DruidSegmentInputEntity;
import org.apache.druid.indexing.input.DruidSegmentReader;
import org.apache.druid.indexing.input.DruidTombstoneSegmentReader;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.IndexIO;

public class DruidSegmentInputFormat
implements InputFormat {
    private final IndexIO indexIO;
    private final DimFilter dimFilter;

    public DruidSegmentInputFormat(IndexIO indexIO, DimFilter dimFilter) {
        this.indexIO = indexIO;
        this.dimFilter = dimFilter;
    }

    public boolean isSplittable() {
        return false;
    }

    public InputEntityReader createReader(InputRowSchema inputRowSchema, InputEntity source, File temporaryDirectory) {
        InputEntity baseInputEntity = source instanceof BytesCountingInputEntity ? ((BytesCountingInputEntity)source).getBaseInputEntity() : source;
        Preconditions.checkArgument((boolean)(baseInputEntity instanceof DruidSegmentInputEntity), (Object)(DruidSegmentInputEntity.class.getName() + " required, but " + baseInputEntity.getClass().getName() + " provided."));
        DruidSegmentInputEntity druidSegmentEntity = (DruidSegmentInputEntity)baseInputEntity;
        if (druidSegmentEntity.isFromTombstone()) {
            return new DruidTombstoneSegmentReader(druidSegmentEntity);
        }
        return new DruidSegmentReader(source, this.indexIO, inputRowSchema.getTimestampSpec(), inputRowSchema.getDimensionsSpec(), inputRowSchema.getColumnsFilter(), this.dimFilter, temporaryDirectory);
    }
}

