/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Preconditions;

public class CriticalAction<T> {
    private final Action<T> actionOnValidLocks;
    private final Action<T> actionOnInvalidLocks;

    private CriticalAction(Action<T> actionOnValidLocks, Action<T> actionOnInvalidLocks) {
        this.actionOnValidLocks = (Action)Preconditions.checkNotNull(actionOnValidLocks, (Object)"actionOnValidLocks");
        this.actionOnInvalidLocks = (Action)Preconditions.checkNotNull(actionOnInvalidLocks, (Object)"actionOnInvalidLocks");
    }

    T perform(boolean isTaskLocksValid) throws Exception {
        return isTaskLocksValid ? this.actionOnValidLocks.perform() : this.actionOnInvalidLocks.perform();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static interface Action<T> {
        public T perform() throws Exception;
    }

    public static class Builder<T> {
        private Action<T> actionOnInvalidLocks;
        private Action<T> actionOnValidLocks;

        public Builder<T> onValidLocks(Action<T> action) {
            this.actionOnValidLocks = action;
            return this;
        }

        public Builder<T> onInvalidLocks(Action<T> action) {
            this.actionOnInvalidLocks = action;
            return this;
        }

        public CriticalAction<T> build() {
            return new CriticalAction(this.actionOnValidLocks, this.actionOnInvalidLocks);
        }
    }
}

