/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.druid.java.util.common.ISE;

public class PortFinder {
    private final Set<Integer> usedPorts = new HashSet<Integer>();
    private final int startPort;
    private final int endPort;
    private final List<Integer> candidatePorts;

    public PortFinder(int startPort, int endPort, List<Integer> candidatePorts) {
        this.startPort = startPort;
        this.endPort = endPort;
        this.candidatePorts = candidatePorts;
    }

    @VisibleForTesting
    boolean canBind(int portNum) {
        try {
            new ServerSocket(portNum).close();
            return true;
        }
        catch (SocketException se) {
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized int findUnusedPort() {
        if (this.candidatePorts != null && !this.candidatePorts.isEmpty()) {
            int port = this.chooseFromCandidates();
            this.usedPorts.add(port);
            return port;
        }
        int port = this.chooseNext(this.startPort);
        while (!this.canBind(port)) {
            port = this.chooseNext(port + 1);
        }
        this.usedPorts.add(port);
        return port;
    }

    public synchronized void markPortUnused(int port) {
        this.usedPorts.remove(port);
    }

    public synchronized int findUsedPortCount() {
        return this.usedPorts.size();
    }

    private int chooseFromCandidates() {
        for (int port : this.candidatePorts) {
            if (this.usedPorts.contains(port) || !this.canBind(port)) continue;
            return port;
        }
        throw new ISE("All ports are used...", new Object[0]);
    }

    private int chooseNext(int start) {
        for (int i = start; i <= this.endPort; ++i) {
            if (this.usedPorts.contains(i)) continue;
            return i;
        }
        throw new ISE("All ports are used...", new Object[0]);
    }
}

