/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.overlord.TaskRunnerWorkItem;
import org.apache.druid.indexing.worker.Worker;
import org.joda.time.DateTime;

public class RemoteTaskRunnerWorkItem
extends TaskRunnerWorkItem {
    private final SettableFuture<TaskStatus> result;
    private String taskType;
    private final String dataSource;
    private Worker worker;
    private TaskLocation location;

    public RemoteTaskRunnerWorkItem(String taskId, String taskType, Worker worker, TaskLocation location, String dataSource) {
        this(taskId, taskType, (SettableFuture<TaskStatus>)SettableFuture.create(), worker, location, dataSource);
    }

    private RemoteTaskRunnerWorkItem(String taskId, String taskType, SettableFuture<TaskStatus> result, Worker worker, TaskLocation location, String dataSource) {
        super(taskId, (ListenableFuture<TaskStatus>)result);
        this.result = result;
        this.taskType = taskType;
        this.worker = worker;
        this.location = location == null ? TaskLocation.unknown() : location;
        this.dataSource = dataSource;
    }

    private RemoteTaskRunnerWorkItem(String taskId, String taskType, SettableFuture<TaskStatus> result, DateTime createdTime, DateTime queueInsertionTime, Worker worker, TaskLocation location, String dataSource) {
        super(taskId, (ListenableFuture<TaskStatus>)result, createdTime, queueInsertionTime);
        this.result = result;
        this.taskType = taskType;
        this.worker = worker;
        this.location = location == null ? TaskLocation.unknown() : location;
        this.dataSource = dataSource;
    }

    public void setLocation(TaskLocation location) {
        this.location = location;
    }

    @Override
    public TaskLocation getLocation() {
        return this.location;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    @Override
    public String getTaskType() {
        return this.taskType;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    public void setWorker(Worker worker) {
        this.worker = worker;
    }

    public Worker getWorker() {
        return this.worker;
    }

    public void setResult(TaskStatus status) {
        this.result.set((Object)status);
    }

    public RemoteTaskRunnerWorkItem withQueueInsertionTime(DateTime time) {
        return new RemoteTaskRunnerWorkItem(this.getTaskId(), this.taskType, this.result, this.getCreatedTime(), time, this.worker, this.location, this.dataSource);
    }

    public RemoteTaskRunnerWorkItem withWorker(Worker theWorker, TaskLocation location) {
        return new RemoteTaskRunnerWorkItem(this.getTaskId(), this.taskType, this.result, this.getCreatedTime(), this.getQueueInsertionTime(), theWorker, location, this.dataSource);
    }
}

