/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.util.concurrent.ListenableFuture;
import javax.annotation.Nullable;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.java.util.common.DateTimes;
import org.joda.time.DateTime;

public abstract class TaskRunnerWorkItem {
    private final String taskId;
    private final ListenableFuture<TaskStatus> result;
    private final DateTime createdTime;
    private final DateTime queueInsertionTime;

    public TaskRunnerWorkItem(String taskId, ListenableFuture<TaskStatus> result) {
        this(taskId, result, DateTimes.nowUtc());
    }

    private TaskRunnerWorkItem(String taskId, ListenableFuture<TaskStatus> result, DateTime createdTime) {
        this(taskId, result, createdTime, createdTime);
    }

    public TaskRunnerWorkItem(String taskId, ListenableFuture<TaskStatus> result, DateTime createdTime, DateTime queueInsertionTime) {
        this.taskId = taskId;
        this.result = result;
        this.createdTime = createdTime;
        this.queueInsertionTime = queueInsertionTime;
    }

    @JsonProperty
    public String getTaskId() {
        return this.taskId;
    }

    @JsonIgnore
    public ListenableFuture<TaskStatus> getResult() {
        return this.result;
    }

    @JsonProperty
    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @JsonProperty
    public DateTime getQueueInsertionTime() {
        return this.queueInsertionTime;
    }

    @JsonProperty
    public abstract TaskLocation getLocation();

    @Nullable
    public abstract String getTaskType();

    public abstract String getDataSource();

    public String toString() {
        return "TaskRunnerWorkItem{taskId='" + this.taskId + '\'' + ", result=" + this.result + ", createdTime=" + this.createdTime + ", queueInsertionTime=" + this.queueInsertionTime + ", location=" + this.getLocation() + '}';
    }
}

