/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.hrtr;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.indexer.TaskStatus;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.ImmutableWorkerInfo;
import org.apache.druid.indexing.overlord.TaskRunnerUtils;
import org.apache.druid.indexing.overlord.config.HttpRemoteTaskRunnerConfig;
import org.apache.druid.indexing.worker.TaskAnnouncement;
import org.apache.druid.indexing.worker.Worker;
import org.apache.druid.indexing.worker.WorkerHistoryItem;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.server.coordination.ChangeRequestHttpSyncer;
import org.apache.druid.server.coordination.ChangeRequestsSnapshot;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.joda.time.DateTime;

public class WorkerHolder {
    private static final EmittingLogger log = new EmittingLogger(WorkerHolder.class);
    public static final TypeReference<ChangeRequestsSnapshot<WorkerHistoryItem>> WORKER_SYNC_RESP_TYPE_REF = new TypeReference<ChangeRequestsSnapshot<WorkerHistoryItem>>(){};
    private final Worker worker;
    private Worker disabledWorker;
    protected final AtomicBoolean disabled;
    protected final AtomicReference<Map<String, TaskAnnouncement>> tasksSnapshotRef;
    private final AtomicReference<DateTime> lastCompletedTaskTime = new AtomicReference<DateTime>(DateTimes.nowUtc());
    private final AtomicReference<DateTime> blacklistedUntil = new AtomicReference();
    private final AtomicInteger continuouslyFailedTasksCount = new AtomicInteger(0);
    private final ChangeRequestHttpSyncer<WorkerHistoryItem> syncer;
    private final ObjectMapper smileMapper;
    private final HttpClient httpClient;
    private final HttpRemoteTaskRunnerConfig config;
    private final Listener listener;

    public WorkerHolder(ObjectMapper smileMapper, HttpClient httpClient, HttpRemoteTaskRunnerConfig config, ScheduledExecutorService workersSyncExec, Listener listener, Worker worker, List<TaskAnnouncement> knownAnnouncements) {
        this.smileMapper = smileMapper;
        this.httpClient = httpClient;
        this.config = config;
        this.listener = listener;
        this.worker = worker;
        this.disabled = new AtomicBoolean(true);
        this.syncer = new ChangeRequestHttpSyncer(smileMapper, httpClient, workersSyncExec, TaskRunnerUtils.makeWorkerURL(worker, "/", new String[0]), "/druid-internal/v1/worker", WORKER_SYNC_RESP_TYPE_REF, config.getSyncRequestTimeout().toStandardDuration().getMillis(), config.getServerUnstabilityTimeout().toStandardDuration().getMillis(), this.createSyncListener());
        ConcurrentHashMap announcements = new ConcurrentHashMap();
        if (knownAnnouncements != null) {
            knownAnnouncements.forEach(e -> announcements.put(e.getTaskId(), e));
        }
        this.tasksSnapshotRef = new AtomicReference(announcements);
    }

    public Worker getWorker() {
        return this.worker;
    }

    public DateTime getBlacklistedUntil() {
        return this.blacklistedUntil.get();
    }

    public void setLastCompletedTaskTime(DateTime completedTaskTime) {
        this.lastCompletedTaskTime.set(completedTaskTime);
    }

    public void setBlacklistedUntil(DateTime blacklistedUntil) {
        this.blacklistedUntil.set(blacklistedUntil);
    }

    public ImmutableWorkerInfo toImmutable() {
        Worker w = this.worker;
        if (this.disabled.get()) {
            if (this.disabledWorker == null) {
                this.disabledWorker = new Worker(this.worker.getScheme(), this.worker.getHost(), this.worker.getIp(), this.worker.getCapacity(), "", this.worker.getCategory());
            }
            w = this.disabledWorker;
        }
        return ImmutableWorkerInfo.fromWorkerAnnouncements(w, this.tasksSnapshotRef.get(), this.lastCompletedTaskTime.get(), this.blacklistedUntil.get());
    }

    public int getContinuouslyFailedTasksCount() {
        return this.continuouslyFailedTasksCount.get();
    }

    public void resetContinuouslyFailedTasksCount() {
        this.continuouslyFailedTasksCount.set(0);
    }

    public void incrementContinuouslyFailedTasksCount() {
        this.continuouslyFailedTasksCount.incrementAndGet();
    }

    public boolean assignTask(Task task) {
        if (this.disabled.get()) {
            log.info("Received task[%s] assignment on worker[%s] when worker is disabled.", new Object[]{task.getId(), this.worker.getHost()});
            return false;
        }
        URL url = TaskRunnerUtils.makeWorkerURL(this.worker, "/druid-internal/v1/worker/assignTask", new String[0]);
        int numTries = this.config.getAssignRequestMaxRetries();
        try {
            return (Boolean)RetryUtils.retry(() -> {
                try {
                    StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, url).addHeader("Content-Type", "application/x-jackson-smile").setContent(this.smileMapper.writeValueAsBytes((Object)task)), (HttpResponseHandler)StatusResponseHandler.getInstance(), this.config.getAssignRequestHttpTimeout().toStandardDuration()).get();
                    if (response.getStatus().getCode() == 200) {
                        return true;
                    }
                    throw new RE("Failed to assign task[%s] to worker[%s]. Response Code[%s] and Message[%s]. Retrying...", new Object[]{task.getId(), this.worker.getHost(), response.getStatus().getCode(), response.getContent()});
                }
                catch (ExecutionException ex) {
                    throw new RE((Throwable)ex, "Request to assign task[%s] to worker[%s] failed. Retrying...", new Object[]{task.getId(), this.worker.getHost()});
                }
            }, e -> !(e instanceof InterruptedException), (int)numTries);
        }
        catch (Exception ex) {
            log.info("Not sure whether task[%s] was successfully assigned to worker[%s].", new Object[]{task.getId(), this.worker.getHost()});
            return true;
        }
    }

    public void shutdownTask(String taskId) {
        URL url = TaskRunnerUtils.makeWorkerURL(this.worker, "/druid/worker/v1/task/%s/shutdown", taskId);
        try {
            RetryUtils.retry(() -> {
                try {
                    StatusResponseHolder response = (StatusResponseHolder)this.httpClient.go(new Request(HttpMethod.POST, url), (HttpResponseHandler)StatusResponseHandler.getInstance(), this.config.getShutdownRequestHttpTimeout().toStandardDuration()).get();
                    if (response.getStatus().getCode() == 200) {
                        log.info("Sent shutdown message to worker: %s, status %s, response: %s", new Object[]{this.worker.getHost(), response.getStatus(), response.getContent()});
                        return null;
                    }
                    throw new RE("Attempt to shutdown task[%s] on worker[%s] failed.", new Object[]{taskId, this.worker.getHost()});
                }
                catch (ExecutionException e) {
                    throw new RE((Throwable)e, "Error in handling post to [%s] for task [%s]", new Object[]{this.worker.getHost(), taskId});
                }
            }, e -> !(e instanceof InterruptedException), (int)this.config.getShutdownRequestMaxRetries());
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("Failed to shutdown task[%s] on worker[%s] failed.", new Object[]{taskId, this.worker.getHost()});
        }
    }

    public void start() {
        this.syncer.start();
    }

    public void stop() {
        this.syncer.stop();
    }

    public void waitForInitialization() throws InterruptedException {
        if (!this.syncer.awaitInitialization()) {
            throw new RE("Failed to sync with worker[%s].", new Object[]{this.worker.getHost()});
        }
    }

    public boolean isInitialized() {
        return this.syncer.isInitialized();
    }

    public boolean isEnabled() {
        return !this.disabled.get();
    }

    public ChangeRequestHttpSyncer<WorkerHistoryItem> getUnderlyingSyncer() {
        return this.syncer;
    }

    public ChangeRequestHttpSyncer.Listener<WorkerHistoryItem> createSyncListener() {
        return new ChangeRequestHttpSyncer.Listener<WorkerHistoryItem>(){

            public void fullSync(List<WorkerHistoryItem> changes) {
                ConcurrentHashMap<String, TaskAnnouncement> newSnapshot = new ConcurrentHashMap<String, TaskAnnouncement>();
                ArrayList<TaskAnnouncement> delta = new ArrayList<TaskAnnouncement>();
                boolean isWorkerDisabled = WorkerHolder.this.disabled.get();
                for (WorkerHistoryItem change : changes) {
                    if (change instanceof WorkerHistoryItem.TaskUpdate) {
                        TaskAnnouncement announcement = ((WorkerHistoryItem.TaskUpdate)change).getTaskAnnouncement();
                        newSnapshot.put(announcement.getTaskId(), announcement);
                        delta.add(announcement);
                        continue;
                    }
                    if (change instanceof WorkerHistoryItem.Metadata) {
                        isWorkerDisabled = ((WorkerHistoryItem.Metadata)change).isDisabled();
                        continue;
                    }
                    log.makeAlert("Got unknown sync update[%s] from worker[%s]. Ignored.", new Object[]{change.getClass().getName(), WorkerHolder.this.worker.getHost()}).emit();
                }
                for (TaskAnnouncement announcement : WorkerHolder.this.tasksSnapshotRef.get().values()) {
                    if (newSnapshot.containsKey(announcement.getTaskId()) || announcement.getTaskStatus().isComplete()) continue;
                    log.warn("task[%s] in state[%s] suddenly disappeared on worker[%s]. failing it.", new Object[]{announcement.getTaskId(), announcement.getStatus(), WorkerHolder.this.worker.getHost()});
                    delta.add(TaskAnnouncement.create(announcement.getTaskId(), announcement.getTaskType(), announcement.getTaskResource(), TaskStatus.failure((String)announcement.getTaskId(), (String)"This task disappeared on the worker where it was assigned. See overlord logs for more details."), announcement.getTaskLocation(), announcement.getTaskDataSource()));
                }
                WorkerHolder.this.tasksSnapshotRef.set(newSnapshot);
                this.notifyListener(delta, isWorkerDisabled);
            }

            public void deltaSync(List<WorkerHistoryItem> changes) {
                ArrayList<TaskAnnouncement> delta = new ArrayList<TaskAnnouncement>();
                boolean isWorkerDisabled = WorkerHolder.this.disabled.get();
                for (WorkerHistoryItem change : changes) {
                    if (change instanceof WorkerHistoryItem.TaskUpdate) {
                        TaskAnnouncement announcement = ((WorkerHistoryItem.TaskUpdate)change).getTaskAnnouncement();
                        WorkerHolder.this.tasksSnapshotRef.get().put(announcement.getTaskId(), announcement);
                        delta.add(announcement);
                        continue;
                    }
                    if (change instanceof WorkerHistoryItem.TaskRemoval) {
                        String taskId = ((WorkerHistoryItem.TaskRemoval)change).getTaskId();
                        TaskAnnouncement announcement = WorkerHolder.this.tasksSnapshotRef.get().remove(taskId);
                        if (announcement == null || announcement.getTaskStatus().isComplete()) continue;
                        log.warn("task[%s] in state[%s] suddenly disappeared on worker[%s]. failing it.", new Object[]{announcement.getTaskId(), announcement.getStatus(), WorkerHolder.this.worker.getHost()});
                        delta.add(TaskAnnouncement.create(announcement.getTaskId(), announcement.getTaskType(), announcement.getTaskResource(), TaskStatus.failure((String)announcement.getTaskId(), (String)"This task disappeared on the worker where it was assigned. See overlord logs for more details."), announcement.getTaskLocation(), announcement.getTaskDataSource()));
                        continue;
                    }
                    if (change instanceof WorkerHistoryItem.Metadata) {
                        isWorkerDisabled = ((WorkerHistoryItem.Metadata)change).isDisabled();
                        continue;
                    }
                    log.makeAlert("Got unknown sync update[%s] from worker[%s]. Ignored.", new Object[]{change.getClass().getName(), WorkerHolder.this.worker.getHost()}).emit();
                }
                this.notifyListener(delta, isWorkerDisabled);
            }

            private void notifyListener(List<TaskAnnouncement> announcements, boolean isWorkerDisabled) {
                for (TaskAnnouncement announcement : announcements) {
                    try {
                        WorkerHolder.this.listener.taskAddedOrUpdated(announcement, WorkerHolder.this);
                    }
                    catch (Exception ex) {
                        log.error((Throwable)ex, "Unknown exception while updating task[%s] state from worker[%s].", new Object[]{announcement.getTaskId(), WorkerHolder.this.worker.getHost()});
                    }
                }
                if (isWorkerDisabled != WorkerHolder.this.disabled.get()) {
                    WorkerHolder.this.disabled.set(isWorkerDisabled);
                    log.info("Worker[%s] disabled set to [%s].", new Object[]{WorkerHolder.this.worker.getHost(), isWorkerDisabled});
                }
            }
        };
    }

    public static interface Listener {
        public void taskAddedOrUpdated(TaskAnnouncement var1, WorkerHolder var2);
    }
}

