/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.indexing.seekablestream.SeekableStreamSequenceNumbers;

public class SeekableStreamStartSequenceNumbers<PartitionIdType, SequenceOffsetType>
implements SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> {
    public static final String TYPE = "start";
    private final String stream;
    private final Map<PartitionIdType, SequenceOffsetType> partitionSequenceNumberMap;
    private final Set<PartitionIdType> exclusivePartitions;

    @JsonCreator
    public SeekableStreamStartSequenceNumbers(@JsonProperty(value="stream") String stream, @JsonProperty(value="topic") String topic, @JsonProperty(value="partitionSequenceNumberMap") Map<PartitionIdType, SequenceOffsetType> partitionSequenceNumberMap, @JsonProperty(value="partitionOffsetMap") Map<PartitionIdType, SequenceOffsetType> partitionOffsetMap, @JsonProperty(value="exclusivePartitions") @Nullable Set<PartitionIdType> exclusivePartitions) {
        this.stream = stream == null ? topic : stream;
        this.partitionSequenceNumberMap = partitionOffsetMap == null ? partitionSequenceNumberMap : partitionOffsetMap;
        Preconditions.checkNotNull((Object)this.stream, (Object)"stream");
        Preconditions.checkNotNull(this.partitionSequenceNumberMap, (Object)"partitionIdToSequenceNumberMap");
        this.exclusivePartitions = exclusivePartitions == null ? Collections.emptySet() : exclusivePartitions;
    }

    public SeekableStreamStartSequenceNumbers(String stream, Map<PartitionIdType, SequenceOffsetType> partitionSequenceNumberMap, Set<PartitionIdType> exclusivePartitions) {
        this(stream, null, partitionSequenceNumberMap, null, exclusivePartitions);
    }

    @Override
    @JsonProperty
    public String getStream() {
        return this.stream;
    }

    @JsonProperty
    public String getTopic() {
        return this.stream;
    }

    @Override
    @JsonProperty
    public Map<PartitionIdType, SequenceOffsetType> getPartitionSequenceNumberMap() {
        return this.partitionSequenceNumberMap;
    }

    @JsonProperty
    public Map<PartitionIdType, SequenceOffsetType> getPartitionOffsetMap() {
        return this.partitionSequenceNumberMap;
    }

    @Override
    public SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> plus(SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> other) {
        this.validateSequenceNumbersBaseType(other);
        SeekableStreamStartSequenceNumbers otherStart = (SeekableStreamStartSequenceNumbers)other;
        if (this.stream.equals(otherStart.stream)) {
            HashMap<PartitionIdType, SequenceOffsetType> newMap = new HashMap<PartitionIdType, SequenceOffsetType>(this.partitionSequenceNumberMap);
            newMap.putAll(otherStart.partitionSequenceNumberMap);
            HashSet<PartitionIdType> newExclusivePartitions = new HashSet<PartitionIdType>();
            this.partitionSequenceNumberMap.forEach((partitionId, sequenceOffset) -> {
                if (this.exclusivePartitions.contains(partitionId) && !otherStart.partitionSequenceNumberMap.containsKey(partitionId)) {
                    newExclusivePartitions.add(partitionId);
                }
            });
            newExclusivePartitions.addAll(otherStart.exclusivePartitions);
            return new SeekableStreamStartSequenceNumbers<PartitionIdType, SequenceOffsetType>(this.stream, newMap, newExclusivePartitions);
        }
        return other;
    }

    @Override
    public int compareTo(SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> other, Comparator<SequenceOffsetType> comparator) {
        this.validateSequenceNumbersBaseType(other);
        SeekableStreamStartSequenceNumbers otherStart = (SeekableStreamStartSequenceNumbers)other;
        if (this.stream.equals(otherStart.stream)) {
            boolean res = false;
            for (Map.Entry<PartitionIdType, SequenceOffsetType> entry : this.partitionSequenceNumberMap.entrySet()) {
                PartitionIdType partitionId = entry.getKey();
                SequenceOffsetType sequenceOffset = entry.getValue();
                if (otherStart.partitionSequenceNumberMap.get(partitionId) == null || comparator.compare(sequenceOffset, otherStart.partitionSequenceNumberMap.get(partitionId)) <= 0) continue;
                res = true;
                break;
            }
            if (res) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> minus(SeekableStreamSequenceNumbers<PartitionIdType, SequenceOffsetType> other) {
        this.validateSequenceNumbersBaseType(other);
        SeekableStreamStartSequenceNumbers otherStart = (SeekableStreamStartSequenceNumbers)other;
        if (this.stream.equals(otherStart.stream)) {
            HashMap<PartitionIdType, SequenceOffsetType> newMap = new HashMap<PartitionIdType, SequenceOffsetType>();
            HashSet<PartitionIdType> newExclusivePartitions = new HashSet<PartitionIdType>();
            for (Map.Entry<PartitionIdType, SequenceOffsetType> entry : this.partitionSequenceNumberMap.entrySet()) {
                if (otherStart.partitionSequenceNumberMap.containsKey(entry.getKey())) continue;
                newMap.put(entry.getKey(), entry.getValue());
                if (!this.exclusivePartitions.contains(entry.getKey())) continue;
                newExclusivePartitions.add(entry.getKey());
            }
            return new SeekableStreamStartSequenceNumbers(this.stream, newMap, newExclusivePartitions);
        }
        return this;
    }

    @JsonProperty
    public Set<PartitionIdType> getExclusivePartitions() {
        return this.exclusivePartitions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeekableStreamStartSequenceNumbers that = (SeekableStreamStartSequenceNumbers)o;
        return Objects.equals(this.stream, that.stream) && Objects.equals(this.partitionSequenceNumberMap, that.partitionSequenceNumberMap) && Objects.equals(this.exclusivePartitions, that.exclusivePartitions);
    }

    public int hashCode() {
        return Objects.hash(this.stream, this.partitionSequenceNumberMap, this.exclusivePartitions);
    }

    public String toString() {
        return "SeekableStreamStartSequenceNumbers{stream='" + this.stream + '\'' + ", partitionSequenceNumberMap=" + this.partitionSequenceNumberMap + ", exclusivePartitions=" + this.exclusivePartitions + '}';
    }
}

