/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.google;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.InputStreamContent;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Date;
import org.apache.druid.common.utils.CurrentTimeMillisSupplier;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.storage.google.GoogleByteSource;
import org.apache.druid.storage.google.GoogleInputDataConfig;
import org.apache.druid.storage.google.GoogleStorage;
import org.apache.druid.storage.google.GoogleStorageObjectMetadata;
import org.apache.druid.storage.google.GoogleTaskLogsConfig;
import org.apache.druid.storage.google.GoogleUtils;
import org.apache.druid.tasklogs.TaskLogs;

public class GoogleTaskLogs
implements TaskLogs {
    private static final Logger LOG = new Logger(GoogleTaskLogs.class);
    static final int UPLOAD_BUFFER_SIZE = 0x100000;
    private final GoogleTaskLogsConfig config;
    private final GoogleStorage storage;
    private final GoogleInputDataConfig inputDataConfig;
    private final CurrentTimeMillisSupplier timeSupplier;

    @Inject
    public GoogleTaskLogs(GoogleTaskLogsConfig config, GoogleStorage storage, GoogleInputDataConfig inputDataConfig, CurrentTimeMillisSupplier timeSupplier) {
        this.config = config;
        this.storage = storage;
        this.inputDataConfig = inputDataConfig;
        this.timeSupplier = timeSupplier;
    }

    public void pushTaskLog(String taskid, File logFile) throws IOException {
        String taskKey = this.getTaskLogKey(taskid);
        LOG.info("Pushing task log %s to: %s", new Object[]{logFile, taskKey});
        this.pushTaskFile(logFile, taskKey);
    }

    public void pushTaskReports(String taskid, File reportFile) throws IOException {
        String taskKey = this.getTaskReportKey(taskid);
        LOG.info("Pushing task reports %s to: %s", new Object[]{reportFile, taskKey});
        this.pushTaskFile(reportFile, taskKey);
    }

    public void pushTaskStatus(String taskid, File statusFile) throws IOException {
        String taskKey = this.getTaskStatusKey(taskid);
        LOG.info("Pushing task status %s to: %s", new Object[]{statusFile, taskKey});
        this.pushTaskFile(statusFile, taskKey);
    }

    private void pushTaskFile(File logFile, String taskKey) throws IOException {
        try (InputStream fileStream = Files.newInputStream(logFile.toPath(), new OpenOption[0]);){
            InputStreamContent mediaContent = new InputStreamContent("text/plain", fileStream);
            mediaContent.setLength(logFile.length());
            try {
                RetryUtils.retry(() -> {
                    this.storage.insert(this.config.getBucket(), taskKey, (AbstractInputStreamContent)mediaContent, 0x100000);
                    return null;
                }, GoogleUtils::isRetryable, (int)1, (int)5);
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RE((Throwable)e, "Failed to upload [%s] to [%s]", new Object[]{logFile, taskKey});
            }
        }
    }

    public Optional<InputStream> streamTaskLog(String taskid, long offset) throws IOException {
        String taskKey = this.getTaskLogKey(taskid);
        return this.streamTaskFile(taskid, offset, taskKey);
    }

    public Optional<InputStream> streamTaskReports(String taskid) throws IOException {
        String taskKey = this.getTaskReportKey(taskid);
        return this.streamTaskFile(taskid, 0L, taskKey);
    }

    public Optional<InputStream> streamTaskStatus(String taskid) throws IOException {
        String taskKey = this.getTaskStatusKey(taskid);
        return this.streamTaskFile(taskid, 0L, taskKey);
    }

    private Optional<InputStream> streamTaskFile(String taskid, long offset, String taskKey) throws IOException {
        try {
            if (!this.storage.exists(this.config.getBucket(), taskKey)) {
                return Optional.absent();
            }
            long length = this.storage.size(this.config.getBucket(), taskKey);
            try {
                long start = offset > 0L && offset < length ? offset : (offset < 0L && -1L * offset < length ? length + offset : 0L);
                return Optional.of((Object)new GoogleByteSource(this.storage, this.config.getBucket(), taskKey).openStream(start));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        catch (IOException e) {
            throw new IOE((Throwable)e, "Failed to stream logs from: %s", new Object[]{taskKey});
        }
    }

    private String getTaskLogKey(String taskid) {
        return this.config.getPrefix() + "/" + taskid.replace(':', '_');
    }

    private String getTaskReportKey(String taskid) {
        return this.config.getPrefix() + "/" + taskid.replace(':', '_') + ".report.json";
    }

    private String getTaskStatusKey(String taskid) {
        return this.config.getPrefix() + "/" + taskid.replace(':', '_') + ".status.json";
    }

    public void killAll() throws IOException {
        LOG.info("Deleting all task logs from gs location [bucket: '%s' prefix: '%s'].", new Object[]{this.config.getBucket(), this.config.getPrefix()});
        long now = this.timeSupplier.getAsLong();
        this.killOlderThan(now);
    }

    public void killOlderThan(long timestampMs) throws IOException {
        LOG.info("Deleting all task logs from gs location [bucket: '%s' prefix: '%s'] older than %s.", new Object[]{this.config.getBucket(), this.config.getPrefix(), new Date(timestampMs)});
        try {
            GoogleUtils.deleteObjectsInPath(this.storage, this.inputDataConfig, this.config.getBucket(), this.config.getPrefix(), (Predicate<GoogleStorageObjectMetadata>)((Predicate)object -> object.getLastUpdateTimeMillis() < timestampMs));
        }
        catch (Exception e) {
            LOG.error("Error occurred while deleting task log files from gs. Error: %s", new Object[]{e.getMessage()});
            throw new IOException(e);
        }
    }
}

