/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ListMeta;
import io.kubernetes.client.openapi.models.V1ListMetaBuilder;
import io.kubernetes.client.openapi.models.V1ListMetaFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimTemplate;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimTemplateBuilder;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimTemplateFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimTemplateList;
import io.kubernetes.client.openapi.models.V1alpha2ResourceClaimTemplateListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha2ResourceClaimTemplateListFluentImpl<A extends V1alpha2ResourceClaimTemplateListFluent<A>>
extends BaseFluent<A>
implements V1alpha2ResourceClaimTemplateListFluent<A> {
    private String apiVersion;
    private ArrayList<V1alpha2ResourceClaimTemplateBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public V1alpha2ResourceClaimTemplateListFluentImpl() {
    }

    public V1alpha2ResourceClaimTemplateListFluentImpl(V1alpha2ResourceClaimTemplateList instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withItems(instance.getItems());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(int index, V1alpha2ResourceClaimTemplate item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        V1alpha2ResourceClaimTemplateBuilder builder = new V1alpha2ResourceClaimTemplateBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").add(index, builder);
            this.items.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToItems(int index, V1alpha2ResourceClaimTemplate item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        V1alpha2ResourceClaimTemplateBuilder builder = new V1alpha2ResourceClaimTemplateBuilder(item);
        if (index < 0 || index >= this.items.size()) {
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(V1alpha2ResourceClaimTemplate ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (V1alpha2ResourceClaimTemplate item : items) {
            V1alpha2ResourceClaimTemplateBuilder builder = new V1alpha2ResourceClaimTemplateBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<V1alpha2ResourceClaimTemplate> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (V1alpha2ResourceClaimTemplate item : items) {
            V1alpha2ResourceClaimTemplateBuilder builder = new V1alpha2ResourceClaimTemplateBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(V1alpha2ResourceClaimTemplate ... items) {
        for (V1alpha2ResourceClaimTemplate item : items) {
            V1alpha2ResourceClaimTemplateBuilder builder = new V1alpha2ResourceClaimTemplateBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<V1alpha2ResourceClaimTemplate> items) {
        for (V1alpha2ResourceClaimTemplate item : items) {
            V1alpha2ResourceClaimTemplateBuilder builder = new V1alpha2ResourceClaimTemplateBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<V1alpha2ResourceClaimTemplateBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<V1alpha2ResourceClaimTemplateBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            V1alpha2ResourceClaimTemplateBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1alpha2ResourceClaimTemplate> getItems() {
        return this.items != null ? V1alpha2ResourceClaimTemplateListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<V1alpha2ResourceClaimTemplate> buildItems() {
        return this.items != null ? V1alpha2ResourceClaimTemplateListFluentImpl.build(this.items) : null;
    }

    @Override
    public V1alpha2ResourceClaimTemplate buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public V1alpha2ResourceClaimTemplate buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public V1alpha2ResourceClaimTemplate buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public V1alpha2ResourceClaimTemplate buildMatchingItem(Predicate<V1alpha2ResourceClaimTemplateBuilder> predicate) {
        for (V1alpha2ResourceClaimTemplateBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<V1alpha2ResourceClaimTemplateBuilder> predicate) {
        for (V1alpha2ResourceClaimTemplateBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<V1alpha2ResourceClaimTemplate> items) {
        if (this.items != null) {
            this._visitables.get("items").clear();
        }
        if (items != null) {
            this.items = new ArrayList();
            for (V1alpha2ResourceClaimTemplate item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(V1alpha2ResourceClaimTemplate ... items) {
        if (this.items != null) {
            this.items.clear();
            this._visitables.remove("items");
        }
        if (items != null) {
            for (V1alpha2ResourceClaimTemplate item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.ItemsNested<A> addNewItemLike(V1alpha2ResourceClaimTemplate item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.ItemsNested<A> setNewItemLike(int index, V1alpha2ResourceClaimTemplate item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.ItemsNested<A> editMatchingItem(Predicate<V1alpha2ResourceClaimTemplateBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public V1ListMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public V1ListMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(V1ListMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new V1ListMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new V1ListMetaBuilder().build());
    }

    @Override
    public V1alpha2ResourceClaimTemplateListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha2ResourceClaimTemplateListFluentImpl that = (V1alpha2ResourceClaimTemplateListFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.items, that.items)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        return Objects.equals(this.metadata, that.metadata);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class ItemsNestedImpl<N>
    extends V1alpha2ResourceClaimTemplateFluentImpl<V1alpha2ResourceClaimTemplateListFluent.ItemsNested<N>>
    implements V1alpha2ResourceClaimTemplateListFluent.ItemsNested<N>,
    Nested<N> {
        V1alpha2ResourceClaimTemplateBuilder builder;
        int index;

        ItemsNestedImpl(int index, V1alpha2ResourceClaimTemplate item) {
            this.index = index;
            this.builder = new V1alpha2ResourceClaimTemplateBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha2ResourceClaimTemplateBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClaimTemplateListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends V1ListMetaFluentImpl<V1alpha2ResourceClaimTemplateListFluent.MetadataNested<N>>
    implements V1alpha2ResourceClaimTemplateListFluent.MetadataNested<N>,
    Nested<N> {
        V1ListMetaBuilder builder;

        MetadataNestedImpl(V1ListMeta item) {
            this.builder = new V1ListMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new V1ListMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha2ResourceClaimTemplateListFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

