/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.rest;

import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.implementation.ImplUtils;
import com.azure.core.implementation.ReflectionSerializable;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.http.rest.ErrorOptions;
import com.azure.core.implementation.http.rest.RequestDataConfiguration;
import com.azure.core.implementation.http.rest.RestProxyBase;
import com.azure.core.implementation.http.rest.RestProxyUtils;
import com.azure.core.implementation.http.rest.SwaggerInterfaceParser;
import com.azure.core.implementation.http.rest.SwaggerMethodParser;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.util.Base64Url;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.json.JsonSerializable;
import com.azure.xml.XmlSerializable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.function.Consumer;

public class SyncRestProxy
extends RestProxyBase {
    public SyncRestProxy(HttpPipeline httpPipeline, SerializerAdapter serializer, SwaggerInterfaceParser interfaceParser) {
        super(httpPipeline, serializer, interfaceParser);
    }

    HttpResponse send(HttpRequest request, Context contextData) {
        return this.httpPipeline.sendSync(request, contextData);
    }

    @Override
    public Object invoke(Object proxy, Method method, RequestOptions options, EnumSet<ErrorOptions> errorOptions, Consumer<HttpRequest> requestCallback, SwaggerMethodParser methodParser, HttpRequest request, Context context) {
        Object object;
        block10: {
            HttpResponseDecoder.HttpDecodedResponse decodedResponse = null;
            context = this.startTracingSpan(methodParser, context);
            AutoCloseable scope = this.tracer.makeSpanCurrent(context);
            try {
                if (options != null && requestCallback != null) {
                    requestCallback.accept(request);
                }
                if (request.getBodyAsBinaryData() != null) {
                    request.setBody(RestProxyUtils.validateLengthSync(request));
                }
                HttpResponse response = this.send(request, context);
                decodedResponse = this.decoder.decodeSync(response, methodParser);
                Object result = this.handleRestReturnType(decodedResponse, methodParser, methodParser.getReturnType(), context, options, errorOptions);
                int statusCode = decodedResponse.getSourceResponse().getStatusCode();
                this.tracer.end(statusCode >= 400 ? String.valueOf(statusCode) : null, null, context);
                object = result;
                if (scope == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.tracer.end(null, (Throwable)e, context);
                    ImplUtils.sneakyThrows(e);
                    return null;
                }
            }
            scope.close();
        }
        return object;
    }

    private HttpResponseDecoder.HttpDecodedResponse ensureExpectedStatus(HttpResponseDecoder.HttpDecodedResponse decodedResponse, SwaggerMethodParser methodParser, RequestOptions options, EnumSet<ErrorOptions> errorOptions) {
        byte[] responseBytes;
        int responseStatusCode = decodedResponse.getSourceResponse().getStatusCode();
        if (methodParser.isExpectedResponseStatusCode(responseStatusCode) || options != null && errorOptions.contains((Object)ErrorOptions.NO_THROW)) {
            return decodedResponse;
        }
        BinaryData responseData = decodedResponse.getSourceResponse().getBodyAsBinaryData();
        byte[] byArray = responseBytes = responseData == null ? null : responseData.toBytes();
        if (responseBytes == null || responseBytes.length == 0) {
            throw SyncRestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), null, null);
        }
        Object decodedBody = decodedResponse.getDecodedBody(responseBytes);
        throw SyncRestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.getSourceResponse(), responseBytes, decodedBody);
    }

    private Object handleRestResponseReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        if (methodParser.isStreamResponse()) {
            return new StreamResponse(response.getSourceResponse());
        }
        if (TypeUtil.isTypeOrSubTypeOf(entityType, Response.class)) {
            Type bodyType = TypeUtil.getRestResponseBodyType(entityType);
            if (TypeUtil.isTypeOrSubTypeOf(bodyType, Void.class)) {
                response.getSourceResponse().close();
                return this.createResponse(response, entityType, null);
            }
            Object bodyAsObject = this.handleBodyReturnType(response, methodParser, bodyType);
            Response httpResponse = this.createResponse(response, entityType, bodyAsObject);
            if (httpResponse == null) {
                return this.createResponse(response, entityType, null);
            }
            return httpResponse;
        }
        return this.handleBodyReturnType(response, methodParser, entityType);
    }

    private Object handleBodyReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        Object result;
        int responseStatusCode = response.getSourceResponse().getStatusCode();
        HttpMethod httpMethod = methodParser.getHttpMethod();
        Type returnValueWireType = methodParser.getReturnValueWireType();
        if (httpMethod == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.class))) {
            result = Boolean.valueOf(responseStatusCode / 100 == 2);
        } else if (TypeUtil.isTypeOrSubTypeOf(entityType, byte[].class)) {
            byte[] responseBodyBytes;
            BinaryData binaryData = response.getSourceResponse().getBodyAsBinaryData();
            byte[] byArray = responseBodyBytes = binaryData != null ? binaryData.toBytes() : null;
            if (returnValueWireType == Base64Url.class) {
                responseBodyBytes = new Base64Url(responseBodyBytes).decodedBytes();
            }
            result = responseBodyBytes != null ? (responseBodyBytes.length == 0 ? null : responseBodyBytes) : null;
        } else {
            result = TypeUtil.isTypeOrSubTypeOf(entityType, InputStream.class) ? response.getSourceResponse().getBodyAsInputStream() : (TypeUtil.isTypeOrSubTypeOf(entityType, BinaryData.class) ? response.getSourceResponse().getBodyAsBinaryData() : response.getDecodedBody(null));
        }
        return result;
    }

    private Object handleRestReturnType(HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse, SwaggerMethodParser methodParser, Type returnType, Context context, RequestOptions options, EnumSet<ErrorOptions> errorOptions) {
        Object result;
        HttpResponseDecoder.HttpDecodedResponse expectedResponse = this.ensureExpectedStatus(httpDecodedResponse, methodParser, options, errorOptions);
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(returnType, Void.class)) {
            expectedResponse.close();
            result = null;
        } else {
            result = this.handleRestResponseReturnType(httpDecodedResponse, methodParser, returnType);
        }
        return result;
    }

    @Override
    public void updateRequest(RequestDataConfiguration requestDataConfiguration, SerializerAdapter serializerAdapter) throws IOException {
        boolean isJson = requestDataConfiguration.isJson();
        HttpRequest request = requestDataConfiguration.getHttpRequest();
        Object bodyContentObject = requestDataConfiguration.getBodyContent();
        if (bodyContentObject == null) {
            return;
        }
        if (ReflectionSerializable.supportsJsonSerializable(bodyContentObject.getClass())) {
            request.setBody(ReflectionSerializable.serializeJsonSerializableToBytes((JsonSerializable)bodyContentObject));
            return;
        }
        if (ReflectionSerializable.supportsXmlSerializable(bodyContentObject.getClass())) {
            request.setBody(ReflectionSerializable.serializeXmlSerializableToBytes((XmlSerializable)bodyContentObject));
            return;
        }
        if (isJson) {
            request.setBody(serializerAdapter.serializeToBytes(bodyContentObject, SerializerEncoding.JSON));
        } else if (bodyContentObject instanceof byte[]) {
            request.setBody((byte[])bodyContentObject);
        } else if (bodyContentObject instanceof String) {
            String bodyContentString = (String)bodyContentObject;
            if (!bodyContentString.isEmpty()) {
                request.setBody(bodyContentString);
            }
        } else if (bodyContentObject instanceof ByteBuffer) {
            request.setBody(BinaryData.fromByteBuffer((ByteBuffer)bodyContentObject));
        } else if (bodyContentObject instanceof InputStream) {
            request.setBody(BinaryData.fromStream((InputStream)bodyContentObject));
        } else {
            SerializerEncoding encoding = SerializerEncoding.fromHeaders(request.getHeaders());
            request.setBody(serializerAdapter.serializeToBytes(bodyContentObject, encoding));
        }
    }
}

