/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.ReflectionSerializable;
import com.azure.core.implementation.jackson.JacksonJsonWriter;
import com.azure.json.JsonSerializable;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.IOException;

final class JsonSerializableSerializer
extends JsonSerializer<JsonSerializable> {
    private static final Module MODULE = new SimpleModule().addSerializer(JsonSerializable.class, (JsonSerializer)new JsonSerializableSerializer());

    JsonSerializableSerializer() {
    }

    public static Module getModule() {
        return new SimpleModule().setSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                return ReflectionSerializable.supportsJsonSerializable(beanDesc.getBeanClass()) ? new JsonSerializableSerializer() : serializer;
            }
        });
    }

    public void serialize(JsonSerializable value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        new JacksonJsonWriter(gen).writeJson(value);
    }

    public Class<JsonSerializable> handledType() {
        return JsonSerializable.class;
    }
}

