/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.autoscaling.ec2;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexing.overlord.autoscaling.ec2.EC2UserData;
import org.apache.druid.java.util.common.StringUtils;

public class StringEC2UserData
implements EC2UserData<StringEC2UserData> {
    private final String data;
    @Nullable
    private final String versionReplacementString;
    private final String version;

    @JsonCreator
    public StringEC2UserData(@JsonProperty(value="data") String data, @JsonProperty(value="versionReplacementString") @Nullable String versionReplacementString, @JsonProperty(value="version") String version) {
        this.data = data;
        this.versionReplacementString = versionReplacementString;
        this.version = version;
    }

    @JsonProperty
    public String getData() {
        return this.data;
    }

    @Nullable
    @JsonProperty
    public String getVersionReplacementString() {
        return this.versionReplacementString;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    public StringEC2UserData withVersion(String _version) {
        return new StringEC2UserData(this.data, this.versionReplacementString, _version);
    }

    @Override
    public String getUserDataBase64() {
        String finalData = this.versionReplacementString != null && this.version != null ? StringUtils.replace((String)this.data, (String)this.versionReplacementString, (String)this.version) : this.data;
        return StringUtils.encodeBase64String((byte[])StringUtils.toUtf8((String)finalData));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringEC2UserData that = (StringEC2UserData)o;
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.versionReplacementString, that.versionReplacementString);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.versionReplacementString, this.version);
    }

    public String toString() {
        return "StringEC2UserData{data='" + this.data + '\'' + ", versionReplacementString='" + this.versionReplacementString + '\'' + ", version='" + this.version + '\'' + '}';
    }
}

