/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.variance;

import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.variance.VarianceAggregatorCollector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;

public abstract class VarianceAggregator
implements Aggregator {
    protected final VarianceAggregatorCollector holder = new VarianceAggregatorCollector();

    public Object get() {
        return this.holder;
    }

    public void close() {
    }

    public float getFloat() {
        throw new UnsupportedOperationException("VarianceAggregator does not support getFloat()");
    }

    public long getLong() {
        throw new UnsupportedOperationException("VarianceAggregator does not support getLong()");
    }

    public double getDouble() {
        throw new UnsupportedOperationException("VarianceAggregator does not support getDouble()");
    }

    public static final class ObjectVarianceAggregator
    extends VarianceAggregator {
        private final BaseObjectColumnValueSelector<?> selector;

        public ObjectVarianceAggregator(BaseObjectColumnValueSelector<?> selector) {
            this.selector = selector;
        }

        public void aggregate() {
            VarianceAggregatorCollector.combineValues(this.holder, this.selector.getObject());
        }
    }

    public static final class LongVarianceAggregator
    extends VarianceAggregator {
        private final boolean noNulls = NullHandling.replaceWithDefault();
        private final BaseLongColumnValueSelector selector;

        public LongVarianceAggregator(BaseLongColumnValueSelector selector) {
            this.selector = selector;
        }

        public void aggregate() {
            if (this.noNulls || !this.selector.isNull()) {
                this.holder.add(this.selector.getLong());
            }
        }
    }

    public static final class DoubleVarianceAggregator
    extends VarianceAggregator {
        private final boolean noNulls = NullHandling.replaceWithDefault();
        private final BaseDoubleColumnValueSelector selector;

        public DoubleVarianceAggregator(BaseDoubleColumnValueSelector selector) {
            this.selector = selector;
        }

        public void aggregate() {
            if (this.noNulls || !this.selector.isNull()) {
                this.holder.add(this.selector.getDouble());
            }
        }
    }

    public static final class FloatVarianceAggregator
    extends VarianceAggregator {
        private final boolean noNulls = NullHandling.replaceWithDefault();
        private final BaseFloatColumnValueSelector selector;

        public FloatVarianceAggregator(BaseFloatColumnValueSelector selector) {
            this.selector = selector;
        }

        public void aggregate() {
            if (this.noNulls || !this.selector.isNull()) {
                this.holder.add(this.selector.getFloat());
            }
        }
    }
}

