/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.datasketches.memory.internal.UnsafeUtil;
import sun.nio.ch.DirectBuffer;

final class AccessByteBuffer {
    static final ByteBuffer ZERO_READ_ONLY_DIRECT_BYTE_BUFFER = ByteBuffer.allocateDirect(0).asReadOnlyBuffer();
    private static final long NIO_BUFFER_ADDRESS_FIELD_OFFSET = UnsafeUtil.getFieldOffset(Buffer.class, "address");
    private static final long NIO_BUFFER_CAPACITY_FIELD_OFFSET = UnsafeUtil.getFieldOffset(Buffer.class, "capacity");
    private static final long BYTE_BUFFER_HB_FIELD_OFFSET = UnsafeUtil.getFieldOffset(ByteBuffer.class, "hb");
    private static final long BYTE_BUFFER_OFFSET_FIELD_OFFSET = UnsafeUtil.getFieldOffset(ByteBuffer.class, "offset");
    final long nativeBaseOffset;
    final long capacityBytes;
    final long regionOffset;
    final Object unsafeObj;
    final boolean resourceReadOnly;
    final ByteOrder byteOrder;

    AccessByteBuffer(ByteBuffer byteBuf) {
        this.capacityBytes = byteBuf.capacity();
        this.resourceReadOnly = byteBuf.isReadOnly();
        this.byteOrder = byteBuf.order();
        boolean direct = byteBuf.isDirect();
        if (direct) {
            this.nativeBaseOffset = ((DirectBuffer)((Object)byteBuf)).address();
            this.unsafeObj = null;
            this.regionOffset = 0L;
        } else {
            this.nativeBaseOffset = 0L;
            this.regionOffset = UnsafeUtil.unsafe.getInt(byteBuf, BYTE_BUFFER_OFFSET_FIELD_OFFSET);
            this.unsafeObj = UnsafeUtil.unsafe.getObject(byteBuf, BYTE_BUFFER_HB_FIELD_OFFSET);
        }
    }

    static ByteBuffer getDummyReadOnlyDirectByteBuffer(long address, int capacity) {
        ByteBuffer buf = ZERO_READ_ONLY_DIRECT_BYTE_BUFFER.duplicate();
        UnsafeUtil.unsafe.putLong(buf, NIO_BUFFER_ADDRESS_FIELD_OFFSET, address);
        UnsafeUtil.unsafe.putInt(buf, NIO_BUFFER_CAPACITY_FIELD_OFFSET, capacity);
        buf.limit(capacity);
        return buf;
    }
}

