/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.storage.postgresql;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.List;
import java.util.Locale;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.metadata.MetadataCASUpdate;
import org.apache.druid.metadata.MetadataStorageConnectorConfig;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.storage.postgresql.PostgreSQLConnectorConfig;
import org.apache.druid.metadata.storage.postgresql.PostgreSQLTablesConfig;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.postgresql.PGProperty;
import org.postgresql.util.PSQLException;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.CallbackFailedException;
import org.skife.jdbi.v2.tweak.HandleCallback;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.skife.jdbi.v2.util.StringMapper;

public class PostgreSQLConnector
extends SQLMetadataConnector {
    private static final Logger log = new Logger(PostgreSQLConnector.class);
    private static final String PAYLOAD_TYPE = "BYTEA";
    private static final String SERIAL_TYPE = "BIGSERIAL";
    private static final String QUOTE_STRING = "\\\"";
    private static final String PSQL_SERIALIZATION_FAILURE_MSG = "ERROR: could not serialize access due to concurrent update";
    private static final String PSQL_SERIALIZATION_FAILURE_SQL_STATE = "40001";
    public static final int DEFAULT_STREAMING_RESULT_SIZE = 100;
    private final DBI dbi;
    private volatile Boolean canUpsert;
    private final String dbTableSchema;

    @Inject
    public PostgreSQLConnector(Supplier<MetadataStorageConnectorConfig> config, Supplier<MetadataStorageTablesConfig> dbTables, PostgreSQLConnectorConfig connectorConfig, PostgreSQLTablesConfig tablesConfig, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        super(config, dbTables, centralizedDatasourceSchemaConfig);
        BasicDataSource datasource = this.getDatasource();
        datasource.setDriverClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        datasource.setDriverClassName("org.postgresql.Driver");
        if (connectorConfig.isUseSSL()) {
            log.info("SSL is enabled on this PostgreSQL connection.", new Object[0]);
            datasource.addConnectionProperty(PGProperty.SSL.getName(), String.valueOf(connectorConfig.isUseSSL()));
            if (connectorConfig.getPassword() != null) {
                datasource.addConnectionProperty(PGProperty.SSL_PASSWORD.getName(), connectorConfig.getPassword());
            }
            if (connectorConfig.getSslFactory() != null) {
                datasource.addConnectionProperty(PGProperty.SSL_FACTORY.getName(), connectorConfig.getSslFactory());
            }
            if (connectorConfig.getSslFactoryArg() != null) {
                datasource.addConnectionProperty(PGProperty.SSL_FACTORY_ARG.getName(), connectorConfig.getSslFactoryArg());
            }
            if (connectorConfig.getSslMode() != null) {
                datasource.addConnectionProperty(PGProperty.SSL_MODE.getName(), connectorConfig.getSslMode());
            }
            if (connectorConfig.getSslCert() != null) {
                datasource.addConnectionProperty(PGProperty.SSL_CERT.getName(), connectorConfig.getSslCert());
            }
            if (connectorConfig.getSslKey() != null) {
                datasource.addConnectionProperty(PGProperty.SSL_KEY.getName(), connectorConfig.getSslKey());
            }
            if (connectorConfig.getSslRootCert() != null) {
                datasource.addConnectionProperty(PGProperty.SSL_ROOT_CERT.getName(), connectorConfig.getSslRootCert());
            }
            if (connectorConfig.getSslHostNameVerifier() != null) {
                datasource.addConnectionProperty(PGProperty.SSL_HOSTNAME_VERIFIER.getName(), connectorConfig.getSslHostNameVerifier());
            }
            if (connectorConfig.getSslPasswordCallback() != null) {
                datasource.addConnectionProperty(PGProperty.SSL_PASSWORD_CALLBACK.getName(), connectorConfig.getSslPasswordCallback());
            }
        }
        this.dbi = new DBI((DataSource)datasource);
        this.dbTableSchema = tablesConfig.getDbTableSchema();
        log.info("Configured PostgreSQL as metadata storage", new Object[0]);
    }

    public String getPayloadType() {
        return PAYLOAD_TYPE;
    }

    public String getSerialType() {
        return SERIAL_TYPE;
    }

    public String getQuoteString() {
        return QUOTE_STRING;
    }

    public int getStreamingFetchSize() {
        return 100;
    }

    public String limitClause(int limit) {
        return String.format(Locale.ENGLISH, "LIMIT %d", limit);
    }

    protected boolean canUpsert(Handle handle) throws SQLException {
        if (this.canUpsert == null) {
            DatabaseMetaData metaData = handle.getConnection().getMetaData();
            this.canUpsert = metaData.getDatabaseMajorVersion() > 9 || metaData.getDatabaseMajorVersion() == 9 && metaData.getDatabaseMinorVersion() >= 5;
        }
        return this.canUpsert;
    }

    public boolean tableExists(Handle handle, String tableName) {
        return !((Query)((Query)handle.createQuery("SELECT tablename FROM pg_catalog.pg_tables WHERE schemaname = :dbTableSchema AND tablename ILIKE :tableName").bind("dbTableSchema", this.dbTableSchema)).bind("tableName", tableName)).map((ResultSetMapper)StringMapper.FIRST).list().isEmpty();
    }

    public Void insertOrUpdate(final String tableName, final String keyColumn, final String valueColumn, final String key, final byte[] value) {
        return (Void)this.getDBI().withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                if (PostgreSQLConnector.this.canUpsert(handle)) {
                    ((Update)((Update)handle.createStatement(StringUtils.format((String)"INSERT INTO %1$s (%2$s, %3$s) VALUES (:key, :value) ON CONFLICT (%2$s) DO UPDATE SET %3$s = EXCLUDED.%3$s", (Object[])new Object[]{tableName, keyColumn, valueColumn})).bind("key", key)).bind("value", value)).execute();
                } else {
                    ((Update)((Update)handle.createStatement(StringUtils.format((String)"BEGIN;\nLOCK TABLE %1$s IN SHARE ROW EXCLUSIVE MODE;\nWITH upsert AS (UPDATE %1$s SET %3$s=:value WHERE %2$s=:key RETURNING *)\n    INSERT INTO %1$s (%2$s, %3$s) SELECT :key, :value WHERE NOT EXISTS (SELECT * FROM upsert)\n;COMMIT;", (Object[])new Object[]{tableName, keyColumn, valueColumn})).bind("key", key)).bind("value", value)).execute();
                }
                return null;
            }
        });
    }

    public boolean compareAndSwap(List<MetadataCASUpdate> updates) {
        try {
            return super.compareAndSwap(updates);
        }
        catch (CallbackFailedException cfe) {
            Throwable root = Throwables.getRootCause((Throwable)cfe);
            if (this.checkRootCauseForPSQLSerializationFailure(root)) {
                return false;
            }
            throw cfe;
        }
    }

    private boolean checkRootCauseForPSQLSerializationFailure(Throwable root) {
        if (root instanceof PSQLException) {
            PSQLException psqlException = (PSQLException)root;
            return PSQL_SERIALIZATION_FAILURE_SQL_STATE.equals(psqlException.getSQLState()) && PSQL_SERIALIZATION_FAILURE_MSG.equals(psqlException.getMessage());
        }
        return false;
    }

    public DBI getDBI() {
        return this.dbi;
    }

    protected boolean connectorIsTransientException(Throwable e) {
        if (e instanceof SQLException) {
            String sqlState = ((SQLException)e).getSQLState();
            return sqlState != null && (sqlState.startsWith("08") || sqlState.startsWith("53"));
        }
        return false;
    }
}

