/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.Connection;
import com.squareup.okhttp.ConnectionPool;
import com.squareup.okhttp.OkAuthenticator;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Route;
import com.squareup.okhttp.internal.AbstractOutputStream;
import com.squareup.okhttp.internal.FaultRecoveringOutputStream;
import com.squareup.okhttp.internal.Util;
import com.squareup.okhttp.internal.http.HttpAuthenticator;
import com.squareup.okhttp.internal.http.HttpEngine;
import com.squareup.okhttp.internal.http.HttpsURLConnectionImpl;
import com.squareup.okhttp.internal.http.OkResponseCache;
import com.squareup.okhttp.internal.http.RawHeaders;
import com.squareup.okhttp.internal.http.RetryableOutputStream;
import com.squareup.okhttp.internal.http.RouteSelector;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketPermission;
import java.net.URL;
import java.security.Permission;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSocketFactory;

public class HttpURLConnectionImpl
extends HttpURLConnection {
    static final int HTTP_TEMP_REDIRECT = 307;
    private static final int MAX_REDIRECTS = 20;
    private static final int MAX_REPLAY_BUFFER_LENGTH = 8192;
    private final boolean followProtocolRedirects;
    final Proxy requestedProxy;
    final ProxySelector proxySelector;
    final CookieHandler cookieHandler;
    final OkResponseCache responseCache;
    final ConnectionPool connectionPool;
    SSLSocketFactory sslSocketFactory;
    HostnameVerifier hostnameVerifier;
    List<String> transports;
    OkAuthenticator authenticator;
    final Set<Route> failedRoutes;
    private final RawHeaders rawRequestHeaders = new RawHeaders();
    private int redirectionCount;
    private FaultRecoveringOutputStream faultRecoveringRequestBody;
    protected IOException httpEngineFailure;
    protected HttpEngine httpEngine;

    public HttpURLConnectionImpl(URL url, OkHttpClient client, OkResponseCache responseCache, Set<Route> failedRoutes) {
        super(url);
        this.followProtocolRedirects = client.getFollowProtocolRedirects();
        this.failedRoutes = failedRoutes;
        this.requestedProxy = client.getProxy();
        this.proxySelector = client.getProxySelector();
        this.cookieHandler = client.getCookieHandler();
        this.connectionPool = client.getConnectionPool();
        this.sslSocketFactory = client.getSslSocketFactory();
        this.hostnameVerifier = client.getHostnameVerifier();
        this.transports = client.getTransports();
        this.authenticator = client.getAuthenticator();
        this.responseCache = responseCache;
    }

    Set<Route> getFailedRoutes() {
        return this.failedRoutes;
    }

    @Override
    public final void connect() throws IOException {
        boolean success;
        this.initHttpEngine();
        while (!(success = this.execute(false))) {
        }
    }

    @Override
    public final void disconnect() {
        if (this.httpEngine != null) {
            if (this.httpEngine.hasResponse()) {
                Util.closeQuietly(this.httpEngine.getResponseBody());
            }
            this.httpEngine.release(true);
        }
    }

    @Override
    public final InputStream getErrorStream() {
        try {
            HttpEngine response = this.getResponse();
            if (response.hasResponseBody() && response.getResponseCode() >= 400) {
                return response.getResponseBody();
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderField(int position) {
        try {
            return this.getResponse().getResponseHeaders().getHeaders().getValue(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderField(String fieldName) {
        try {
            RawHeaders rawHeaders = this.getResponse().getResponseHeaders().getHeaders();
            return fieldName == null ? rawHeaders.getStatusLine() : rawHeaders.get(fieldName);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final String getHeaderFieldKey(int position) {
        try {
            return this.getResponse().getResponseHeaders().getHeaders().getFieldName(position);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final Map<String, List<String>> getHeaderFields() {
        try {
            return this.getResponse().getResponseHeaders().getHeaders().toMultimap(true);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public final Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Cannot access request header fields after connection is set");
        }
        return this.rawRequestHeaders.toMultimap(false);
    }

    @Override
    public final InputStream getInputStream() throws IOException {
        if (!this.doInput) {
            throw new ProtocolException("This protocol does not support input");
        }
        HttpEngine response = this.getResponse();
        if (this.getResponseCode() >= 400) {
            throw new FileNotFoundException(this.url.toString());
        }
        InputStream result = response.getResponseBody();
        if (result == null) {
            throw new ProtocolException("No response body exists; responseCode=" + this.getResponseCode());
        }
        return result;
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        this.connect();
        OutputStream out = this.httpEngine.getRequestBody();
        if (out == null) {
            throw new ProtocolException("method does not support a request body: " + this.method);
        }
        if (this.httpEngine.hasResponse()) {
            throw new ProtocolException("cannot write request body after response has been read");
        }
        if (this.faultRecoveringRequestBody == null) {
            this.faultRecoveringRequestBody = new FaultRecoveringOutputStream(8192, out){

                @Override
                protected OutputStream replacementStream(IOException e) throws IOException {
                    if (HttpURLConnectionImpl.this.httpEngine.getRequestBody() instanceof AbstractOutputStream && ((AbstractOutputStream)HttpURLConnectionImpl.this.httpEngine.getRequestBody()).isClosed()) {
                        return null;
                    }
                    if (HttpURLConnectionImpl.this.handleFailure(e)) {
                        return HttpURLConnectionImpl.this.httpEngine.getRequestBody();
                    }
                    return null;
                }
            };
        }
        return this.faultRecoveringRequestBody;
    }

    @Override
    public final Permission getPermission() throws IOException {
        String hostName = this.getURL().getHost();
        int hostPort = Util.getEffectivePort(this.getURL());
        if (this.usingProxy()) {
            InetSocketAddress proxyAddress = (InetSocketAddress)this.requestedProxy.address();
            hostName = proxyAddress.getHostName();
            hostPort = proxyAddress.getPort();
        }
        return new SocketPermission(hostName + ":" + hostPort, "connect, resolve");
    }

    @Override
    public final String getRequestProperty(String field) {
        if (field == null) {
            return null;
        }
        return this.rawRequestHeaders.get(field);
    }

    private void initHttpEngine() throws IOException {
        if (this.httpEngineFailure != null) {
            throw this.httpEngineFailure;
        }
        if (this.httpEngine != null) {
            return;
        }
        this.connected = true;
        try {
            if (this.doOutput) {
                if (this.method.equals("GET")) {
                    this.method = "POST";
                } else if (!this.method.equals("POST") && !this.method.equals("PUT")) {
                    throw new ProtocolException(this.method + " does not support writing");
                }
            }
            this.httpEngine = this.newHttpEngine(this.method, this.rawRequestHeaders, null, null);
        }
        catch (IOException e) {
            this.httpEngineFailure = e;
            throw e;
        }
    }

    protected HttpURLConnection getHttpConnectionToCache() {
        return this;
    }

    private HttpEngine newHttpEngine(String method, RawHeaders requestHeaders, Connection connection, RetryableOutputStream requestBody) throws IOException {
        if (this.url.getProtocol().equals("http")) {
            return new HttpEngine(this, method, requestHeaders, connection, requestBody);
        }
        if (this.url.getProtocol().equals("https")) {
            return new HttpsURLConnectionImpl.HttpsEngine(this, method, requestHeaders, connection, requestBody);
        }
        throw new AssertionError();
    }

    private HttpEngine getResponse() throws IOException {
        this.initHttpEngine();
        if (this.httpEngine.hasResponse()) {
            return this.httpEngine;
        }
        while (true) {
            if (!this.execute(true)) {
                continue;
            }
            Retry retry = this.processResponseHeaders();
            if (retry == Retry.NONE) {
                this.httpEngine.automaticallyReleaseConnectionToPool();
                return this.httpEngine;
            }
            String retryMethod = this.method;
            OutputStream requestBody = this.httpEngine.getRequestBody();
            int responseCode = this.getResponseCode();
            if (responseCode == 300 || responseCode == 301 || responseCode == 302 || responseCode == 303) {
                retryMethod = "GET";
                requestBody = null;
            }
            if (requestBody != null && !(requestBody instanceof RetryableOutputStream)) {
                throw new HttpRetryException("Cannot retry streamed HTTP body", this.httpEngine.getResponseCode());
            }
            if (retry == Retry.DIFFERENT_CONNECTION) {
                this.httpEngine.automaticallyReleaseConnectionToPool();
            }
            this.httpEngine.release(false);
            this.httpEngine = this.newHttpEngine(retryMethod, this.rawRequestHeaders, this.httpEngine.getConnection(), (RetryableOutputStream)requestBody);
        }
    }

    private boolean execute(boolean readResponse) throws IOException {
        try {
            this.httpEngine.sendRequest();
            if (readResponse) {
                this.httpEngine.readResponse();
            }
            return true;
        }
        catch (IOException e) {
            if (this.handleFailure(e)) {
                return false;
            }
            throw e;
        }
    }

    private boolean handleFailure(IOException e) throws IOException {
        OutputStream requestBody;
        boolean canRetryRequestBody;
        RouteSelector routeSelector = this.httpEngine.routeSelector;
        if (routeSelector != null && this.httpEngine.connection != null) {
            routeSelector.connectFailed(this.httpEngine.connection, e);
        }
        boolean bl = canRetryRequestBody = (requestBody = this.httpEngine.getRequestBody()) == null || requestBody instanceof RetryableOutputStream || this.faultRecoveringRequestBody != null && this.faultRecoveringRequestBody.isRecoverable();
        if (routeSelector == null && this.httpEngine.connection == null || routeSelector != null && !routeSelector.hasNext() || !this.isRecoverable(e) || !canRetryRequestBody) {
            this.httpEngineFailure = e;
            return false;
        }
        this.httpEngine.release(true);
        RetryableOutputStream retryableOutputStream = requestBody instanceof RetryableOutputStream ? (RetryableOutputStream)requestBody : null;
        this.httpEngine = this.newHttpEngine(this.method, this.rawRequestHeaders, null, retryableOutputStream);
        this.httpEngine.routeSelector = routeSelector;
        if (this.faultRecoveringRequestBody != null && this.faultRecoveringRequestBody.isRecoverable()) {
            this.httpEngine.sendRequest();
            this.faultRecoveringRequestBody.replaceStream(this.httpEngine.getRequestBody());
        }
        return true;
    }

    private boolean isRecoverable(IOException e) {
        boolean sslFailure = e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException;
        boolean protocolFailure = e instanceof ProtocolException;
        return !sslFailure && !protocolFailure;
    }

    public HttpEngine getHttpEngine() {
        return this.httpEngine;
    }

    private Retry processResponseHeaders() throws IOException {
        Proxy selectedProxy = this.httpEngine.connection != null ? this.httpEngine.connection.getRoute().getProxy() : this.requestedProxy;
        int responseCode = this.getResponseCode();
        switch (responseCode) {
            case 407: {
                if (selectedProxy.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
            }
            case 401: {
                boolean credentialsFound = HttpAuthenticator.processAuthHeader(this.authenticator, this.getResponseCode(), this.httpEngine.getResponseHeaders().getHeaders(), this.rawRequestHeaders, selectedProxy, this.url);
                return credentialsFound ? Retry.SAME_CONNECTION : Retry.NONE;
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                boolean samePort;
                if (!this.getInstanceFollowRedirects()) {
                    return Retry.NONE;
                }
                if (++this.redirectionCount > 20) {
                    throw new ProtocolException("Too many redirects: " + this.redirectionCount);
                }
                if (responseCode == 307 && !this.method.equals("GET") && !this.method.equals("HEAD")) {
                    return Retry.NONE;
                }
                String location = this.getHeaderField("Location");
                if (location == null) {
                    return Retry.NONE;
                }
                URL previousUrl = this.url;
                this.url = new URL(previousUrl, location);
                if (!this.url.getProtocol().equals("https") && !this.url.getProtocol().equals("http")) {
                    return Retry.NONE;
                }
                boolean sameProtocol = previousUrl.getProtocol().equals(this.url.getProtocol());
                if (!sameProtocol && !this.followProtocolRedirects) {
                    return Retry.NONE;
                }
                boolean sameHost = previousUrl.getHost().equals(this.url.getHost());
                boolean bl = samePort = Util.getEffectivePort(previousUrl) == Util.getEffectivePort(this.url);
                if (sameHost && samePort && sameProtocol) {
                    return Retry.SAME_CONNECTION;
                }
                return Retry.DIFFERENT_CONNECTION;
            }
        }
        return Retry.NONE;
    }

    final int getFixedContentLength() {
        return this.fixedContentLength;
    }

    final int getChunkLength() {
        return this.chunkLength;
    }

    @Override
    public final boolean usingProxy() {
        return this.requestedProxy != null && this.requestedProxy.type() != Proxy.Type.DIRECT;
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.getResponse().getResponseHeaders().getHeaders().getResponseMessage();
    }

    @Override
    public final int getResponseCode() throws IOException {
        return this.getResponse().getResponseCode();
    }

    @Override
    public final void setRequestProperty(String field, String newValue) {
        if (this.connected) {
            throw new IllegalStateException("Cannot set request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        this.rawRequestHeaders.set(field, newValue);
    }

    @Override
    public final void addRequestProperty(String field, String value) {
        if (this.connected) {
            throw new IllegalStateException("Cannot add request property after connection is made");
        }
        if (field == null) {
            throw new NullPointerException("field == null");
        }
        this.rawRequestHeaders.add(field, value);
    }

    static enum Retry {
        NONE,
        SAME_CONNECTION,
        DIFFERENT_CONNECTION;

    }
}

